% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rates.R
\name{ESD}
\alias{ESD}
\title{Compute Expected Squared Divergence (ESD) for Evolutionary Models}
\usage{
ESD(y, dt, model = c("GRW", "URW", "Stasis", "allThree"),
  method = c("Joint", "AD"), pool = TRUE, ...)
}
\arguments{
\item{y}{a \code{paleoTS} object}

\item{dt}{the time interval to evaluate ESD}

\item{model}{the model of evolution to assume; see Details}

\item{method}{Joint or AD parameterization}

\item{pool}{logical, if TRUE, variances are averaged (pooled) across samples}

\item{...}{other arguments to the model-fitting functions}
}
\value{
the ESD value
}
\description{
Computes for a specified model and duration of time the
  expected squared divergence (ESD), which is a useful measure of the
  magnitude or rate of change across different models.
}
\details{
Hunt (2012) argued that rate metrics make sense only in the context
  of specific models of evolution.  It is thus difficult to meaningfully
  compare rates across sequences generated by different evolutionary
  processes.  ESD values can be used for a specified model and duration as a
  comparable measure of the amount of evolutionary change that is expected.
  Acceptable values for the model argument can be "GRW" for the general
  random walk (directional change), "URW" for the unbiased random walk, and
  "Stasis."  In addition, one can also specify "allThree", in which case all
  these models will be fit and the resulting ESD will be the weighted average
  of them, using model support (Akaike weights) for the weighting (see Hunt
  [2012], p. 370)
}
\examples{
  x<- sim.GRW(ns=20)
  esd.urw<- ESD(x, dt=10, model="URW")
  esd.all<- ESD(x, dt=10, model="allThree")
}
\references{
Hunt, G. 2012. Measuring rates of phenotypic evolution and the
 inseparability of tempo and mode. \emph{Paleobiology} 38:351–373.
}
