% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/local.R
\name{local_install}
\alias{local_install}
\title{Install a package tree}
\usage{
local_install(
  root = ".",
  lib = .libPaths()[1],
  upgrade = TRUE,
  ask = interactive(),
  dependencies = NA
)
}
\arguments{
\item{root}{Path to the package tree.}

\item{lib}{Package library to install the packages to. Note that \emph{all}
dependent packages will be installed here, even if they are
already installed in another library. The only exceptions are base
and recommended packages installed in \code{.Library}. These are not
duplicated in \code{lib}, unless a newer version of a recommemded package
is needed.}

\item{upgrade}{When \code{FALSE}, the default, pak does the minimum amount
of work to give you the latest version(s) of \code{pkg}. It will only upgrade
dependent packages if \code{pkg}, or one of their dependencies explicitly
require a higher version than what you currently have. It will also
prefer a binary package over to source package, even it the binary
package is older.

When \code{upgrade = TRUE}, pak will ensure that you have the latest
version(s) of \code{pkg} and all their dependencies.}

\item{ask}{Whether to ask for confirmation when installing a different
version of a package that is already installed. Installations that only
add new packages never require confirmation.}

\item{dependencies}{What kinds of dependencies to install. Most commonly
one of the following values:
\itemize{
\item \code{NA}: only required (hard) dependencies,
\item \code{TRUE}: required dependencies plus optional and development
dependencies,
\item \code{FALSE}: do not install any dependencies. (You might end up with a
non-working package, and/or the installation might fail.)
See \link{Package dependency types} for other possible values and more
information about package dependencies.
}}
}
\value{
Data frame, with information about the installed package(s).
}
\description{
Installs a package tree (or source package file), together with its
dependencies.
}
\details{
\code{local_install()} is equivalent to \code{pkg_install("local::.")}.
}
\seealso{
Other local package trees: 
\code{\link{local_deps_explain}()},
\code{\link{local_deps}()},
\code{\link{local_install_deps}()},
\code{\link{local_install_dev_deps}()},
\code{\link{local_package_trees}},
\code{\link{pak}()}
}
\concept{local package trees}
