% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paged.R
\name{html_paged}
\alias{html_paged}
\title{Create a paged HTML document suitable for printing}
\usage{
html_paged(..., css = c("default-fonts", "default-page", "default"), theme = NULL, 
    template = pkg_resource("html", "paged.html"), csl = NULL)
}
\arguments{
\item{...}{Arguments passed to
\code{bookdown::\link[bookdown]{html_document2}}.}

\item{css}{A character vector of CSS file paths. If a path does not contain
the \file{.css} extension, it is assumed to be a built-in CSS file. For
example, \code{default-fonts} means the file
\code{pagedown:::pkg_resource('css', 'default-fonts.css')}. To see all
built-in CSS files, run \code{pagedown:::list_css()}.}

\item{theme}{The Bootstrap theme. By default, Bootstrap is not used.}

\item{template}{The path to the Pandoc template to convert Markdown to HTML.}

\item{csl}{The path of the Citation Style Language (CSL) file used to format
citations and references (see the \href{https://pandoc.org/MANUAL.html#citations}{Pandoc documentation}).}
}
\value{
An R Markdown output format.
}
\description{
This is an output format based on \code{bookdown::html_document2} (which
means you can use those Markdown features added by \pkg{bookdown}). The HTML
output document is split into multiple pages via a JavaScript library
\pkg{paged.js}. These pages contain elements commonly seen in PDF documents,
such as page numbers and running headers.
}
\references{
\url{https://pagedown.rbind.io}
}
