% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coverage_plot.r
\name{theme_coverage_plot}
\alias{theme_coverage_plot}
\title{A minimalistic ggplot2 theme designed for use with genome coverage plots}
\usage{
theme_coverage_plot(facet_labs = TRUE, show_legend = TRUE)
}
\arguments{
\item{facet_labs}{logical  If TRUE (default), label sequences using the facet
labels; if FALSE, sequences are labeled directly using 
\code{\link[ggplot2]{geom_text}}}

\item{show_legend}{logical  If TRUE (default), label display any legend
associated with the fill parameter of \code{plot_coverage}; if FALSE, 
do not display a legend}
}
\description{
This theme is used as the default when \code{\link{plot_coverage}} is called,
so you should usually only call this function to modify the appearance of the
coverage plot.
}
\examples{
ali <- read_paf( system.file("extdata", "fungi.paf", package="pafr") )
plot_coverage(ali) + theme_coverage_plot(show_legend=FALSE)
}
