% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/size.R
\name{app_size}
\alias{app_size}
\title{Size of the shiny app}
\usage{
app_size(
  path = ".",
  fields = c("Depends", "Imports", "LinkingTo"),
  lib.loc = .libPaths(),
  recursive = TRUE
)
}
\arguments{
\item{path}{path to the shiny app. Default: \code{"."}}

\item{fields}{a character vector listing the types of dependencies, a subset of c("Depends", "Imports", "LinkingTo", "Suggests", "Enhances").
Character string "all" is shorthand for that vector, character string "most" for the same vector without "Enhances", character string "strong" (default) for the first three elements of that vector.
Default: \code{c("Depends", "Imports", "LinkingTo")}}

\item{lib.loc}{character vector, used optionally when local is equal TRUE. Default: \code{.libPaths()}}

\item{recursive}{logical if to assess the dependencies recursively. Default: TRUE}
}
\value{
numeric size in bytes, to get MB ten divide by \code{10**6}.
}
\description{
The size of shiny app is a sum of dependencies packages and the app directory.
The app dependencies packages are checked recursively, and only in local repository.
The default arguments setup is recommended.
}
\examples{
\dontrun{
# Please update the path to the shiny app
cat(pacs::app_size(system.file("examples/04_mpg", package = "shiny")) / 10**6, "MB")
}
}
