\name{pacotestRvineSingleCopula}
\alias{pacotestRvineSingleCopula}

\title{
Testing for a Single (j-1)-th Order Partial Copula in a R-Vine Copula
}

\description{
The function can be used to test a single copula in a R-vine copula to be a (j-1)-th order partial copula.
To apply the function one needs to provide the data and a specified/estimated R-vine copula model in form of a \link[VineCopula]{RVineMatrix} from the \link[VineCopula]{VineCopula-package}.
Additionally, a pacotest options list, which can be generated with the \code{\link{pacotestset}} function, needs to be provided.
}

\usage{
pacotestRvineSingleCopula(data, RVM, pacotestOptions, tree, copulaNumber)
}

\arguments{
  \item{data}{
  A (n x d) matrix (or data frame) of [0,1] data (i.e. uniform margins).
  }
  \item{RVM}{
  An \link[VineCopula]{RVineMatrix} object (\link[VineCopula]{VineCopula-package}) which includes the structure, the pair-copula families and parameters of an R-vine copula.
  }
  \item{pacotestOptions}{
  A options list generated by the \code{\link{pacotestset}} function or the test type as string, i.e., \code{CCC} or \code{VI}.
  }
  \item{tree}{
  The tree number (j>=2) of the copula which should be tested to be a (j-1)-th order partial copula.
  }
  \item{copulaNumber}{
  The number (1<= copulaNumber <= j-1) of the copula in the normalized \link[VineCopula]{RVineMatrix} which should be tested to be a (j-1)-th order partial copula.
  }
}

\value{
A list which can, depending on the chosen test, consist of the following elements:
\item{pValue}{
The p-value of the test.
}
\item{testStat}{
The value of the test statistic.
}
\item{decisionTree}{
The decision tree used to partition the support Lmabda0 of the conditioning variable W. It is provided as a list consisting of three nodes (\code{CentralNode}, \code{LeftNode} and \code{RightNode}) represented as lists and the variable \code{LeavesForFinalComparison}. Each node consists of the \code{Variable} used to perform the split, the corresponding \code{Quantile} and \code{Threshold}.
}
\item{S}{
The bootstrapped values of the test statistic (only for the test type \code{VI}).
}
}

\author{
Malte S. Kurz
}

\seealso{
\code{\link{pacotest-package}}, \code{\link{pacotest}}, \code{\link{pacotestset}}, \code{\link{pacotestRvineSeq}}
}

\references{
Kurz, M. S. and F. Spanhel (2017), "Testing the simplifying assumption in high-dimensional vine copulas", ArXiv e-prints \url{https://arxiv.org/abs/1706.02338}.

Spanhel, F. and M. S. Kurz (2019), "Simplified vine copula models: Approximations based on the simplifying assumption", Electronic Journal of Statistics 13 (1), 1254-1291.
}

\examples{
\donttest{# Sample data and R-vine copula selection are taken
# from the documentation of RVineStructureSelect
# of the VineCopula package.

# Obtain sample data
data(daxreturns, package ="VineCopula")
dataSet = daxreturns[1:750,1:4]

# Specify an R-vine copula model
# (can be obtained by calling: RVM = VineCopula::RVineStructureSelect(dataSet))
vineStructure = matrix(c(3,4,1,2,0,2,4,1,0,0,1,4,0,0,0,4),4,4)
families = matrix(c(0,5,2,2,0,0,2,14,0,0,0,14,0,0,0,0),4,4)
par = matrix(c(0,0.8230664,0.1933472,0.6275062,
             0,0,0.2350109,1.6619945,
             0,0,0,1.599363,
             0,0,0,0),4,4)
par2 = matrix(c(0,0,11.757700,4.547847,
             0,0,17.15717,0,
             0,0,0,0,0,0,0,0),4,4)
RVM = VineCopula::RVineMatrix(vineStructure, families, par, par2)

# Specify a pacotestOptions list:
# For illustrating the functioning of the decision tree,
# grouped scatterplots and a decision tree plot are activated.
pacotestOptions = pacotestset(testType='CCC',
                               groupedScatterplots = TRUE,
                               decisionTreePlot = TRUE)

# Test for a 2-nd order partial copula
# corresponding to the variables BAYN.DE,BMW.DE
# and conditioning set ALV.DE,BAS.DE
tree = 3
copulaNumber = 1

pacotestResultList = pacotestRvineSingleCopula(dataSet, RVM,
                                                pacotestOptions, tree, copulaNumber)}
}

