% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_pcoord.r
\name{add_pcoord}
\alias{add_pcoord}
\title{Principal Coordinates analysis of phylogenetic distance matrices}
\usage{
add_pcoord(D, correction = "none")
}
\arguments{
\item{D}{A list with objects H, P, and HP, as returned by \code{paco::prepare_paco_data}.}

\item{correction}{In some cases, phylogenetic distance matrices are non-Euclidean which generates negative eigenvalues when those matrices are translated into Principal Coordinates. There are several methods to correct negative eigenvalues. Correction options available here are "cailliez", "lingoes", and "none". The "cailliez" and "lingoes" corrections add a constant to the eigenvalues to make them non-negative. Default is "none".}
}
\value{
The list that was input as the argument `D' with four new elements; the Principal Coordinates of the `host' distance matrix and the Principal Coordinates of the `parasite' distance matrix, as well as, a `correction' object stating the correction used for negative eigenvalues and a `note' object stating whether or not negative eigenvalues were present and therefore corrected.
}
\description{
Translates the distance matrices of 'host' and 'parasite' phylogenies into Principal Coordinates, as needed for Procrustes superimposition.
}
\note{
To find the Principal Coordinates of each distance matrix, we internally a modified version of the function \code{ape::pcoa} that uses \code{vegan::eigenvals} and zapsmall
}
\examples{
data(gopherlice)
library(ape)
gdist <- cophenetic(gophertree)
ldist <- cophenetic(licetree)
D <- prepare_paco_data(gdist, ldist, gl_links)
D <- add_pcoord(D)
}
