% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/packagefinder.r
\name{buildIndex}
\alias{buildIndex}
\title{Creating a search index for findPackage()}
\usage{
buildIndex(filename = "", download.stats = FALSE)
}
\arguments{
\item{filename}{Name of .rdata file to which the new index is saved.}

\item{download.stats}{Indicates if the search index shall include download figures from the RStudio CRAN mirror logs.}
}
\value{
Returns the search index. As a side effect, the index is saved to a file, if a filename is provided via the \code{filename} argument.
}
\description{
Builds a search index that can be used with \code{\link{findPackage}()}.
}
\details{
Functions like \code{\link{findPackage}()} or \code{\link{go}()} require a search index. This search index can either be created on-the-fly or be provided as a separate argument. In the latter case a search index can be built using \code{buildIndex()}. This index can include download figures for the packages
(this feature is turned on with \code{download.stats = TRUE}). Including download stats requires significant time (may well be > 1 hour) for the index to be built. Therefore, when \code{\link{findPackage}()} is called without
providing an index, the index that is created on-the-fly does not contain CRAN download figures.
}
\examples{
index <- buildIndex(filename = file.path(tempdir(), "searchindex.rdata"), download.stats = FALSE)

}
\author{
Joachim Zuckarelli \email{joachim@zuckarelli.de}
}
