hist_boxplot <-
function(x,freq=TRUE,density=FALSE,main=NULL,xlab=NULL,...){
  abs <- deparse(substitute(x))
  if (is.null(xlab)){xlab=abs}
  ted <- hist(x,plot=FALSE)
  par(yaxs="i")
  if (freq){
    ylim=c(-(max(ted$counts)/5),max(ted$counts))
    boxwex=max(ted$counts)/6
  } else{
    if (density){
      max=max(max(density(x)$y),max(ted$density))
    } else{
      max=max(ted$density)
    }
    ylim=c(-max/5,max)
    boxwex=max/6    
  }
  if (is.null(main)){main=paste("Histogram of",abs)}
  hist(x,ylim=ylim,yaxt="n",xlab=xlab,freq=freq,main=main,...)
  axis(2,at=seq(0,ylim[2],length=5))
  usrs <- par()$usr
  par(new=TRUE,bty="n",xaxs="i",yaxs="i",ann=FALSE)
  boxplot(x,horizontal=TRUE,ylim=usrs[1:2],add=TRUE,at=usrs[3]/2,pars=list(boxwex=5),col="lightblue",boxwex=boxwex)
  if (density){
    lines(density(x),lwd=2,col="red")
  }
}
