% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_box.R
\name{plot_box}
\alias{plot_box}
\alias{plot_box,Raster-method}
\alias{plot_box,data.table-method}
\alias{plot_box,character-method}
\title{Boxplot ggplot}
\usage{
plot_box(x, var = "Precipitation", unit = "mm")

\S4method{plot_box}{Raster}(x, var = "Precipitation", unit = "mm")

\S4method{plot_box}{data.table}(x, var = "Precipitation", unit = "mm")

\S4method{plot_box}{character}(x, var = "Precipitation", unit = "mm")
}
\arguments{
\item{x}{Raster* object; data.table (see details); filename (character, see details)}

\item{var}{character (see details)}

\item{unit}{character (see details)}
}
\value{
ggplot object
}
\description{
Convenient and aesthetic visualization of data in a boxplot.
}
\details{
If `x` is a data.table, its columns should be named: "lon", "lat", "date", and "value"

If `x` is a filename, it should point to a *.nc file.

`var` is a character string describing the variable to be used for the plot title

`unit` is a character string describing the unit of measurement to be used for the plot title
}
\examples{
\dontrun{
download_data("gldas-vic", tempdir(), timestep = "yearly")
r <- raster::brick(paste0(tempdir(),
"/gldas-vic_tp_mm_land_194801_201412_025_yearly.nc"))
s <- plot_box(r)
}
}
