#' Probability Of Detection
#'
#' Function for calculating the probability of detection.
#'
#' @import data.table
#' @param x a data.table generated by \code{\link{make_ts}}
#' @param ref a data.table with data used for evaluation
#' @param th numeric. The value for detection threshold
#' @return numeric
#' @export

pod <- function(x, ref, th){
  setnames(x, 'value', 'forecast')
  setnames(ref, 'value', 'observed')
  dummie_table <- merge(ref, x, by = 'date', allow.cartesian = TRUE)
  dummie_table <- dummie_table[forecast > th & observed > th, A := 1
                               ][forecast > th & observed < th, B := 1
                                 ][forecast < th & observed > th, C := 1
                                   ][forecast < th & observed < th, D := 1]
  dummie_A <- sum(dummie_table$A, na.rm = TRUE)
  dummie_B <- sum(dummie_table$B, na.rm = TRUE)
  dummie_C <- sum(dummie_table$C, na.rm = TRUE)
  dummie_D <- sum(dummie_table$D, na.rm = TRUE)
  dummie <- dummie_A/(dummie_A + dummie_C)
  return(dummie)
}