#' Precipitation heatmap
#'
#' Function for plotting (heatmap) time-series of area averaged precipitation.
#'
#' @import data.table ggplot2
#' @importFrom methods as
#' @param dummie a csv generated by \code{\link{make_ts}}
#' @return ggplot object
#' @export

plot_heatmap <- function(dummie){
  dummie <- as.data.table(dummie)
  p00 <- ggplot(dummie, aes(x = year(date), y = month(date))) + 
    geom_raster(aes(fill = value)) +
    scale_x_continuous(breaks = seq(min(year(dummie$date)),
                                    max(year(dummie$date))), expand = c(0,0)) +
    scale_y_reverse(breaks = seq(1, 12),
                    labels = c("Jan", "Feb", "Mar", "Apr", "May", "Jun",
                               "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"),
                    expand = c(0,0)) +
    theme_bw() +
    scale_fill_viridis_c(direction = -1) +
    coord_equal() +
    labs(x = NULL, y = NULL, fill = "[mm]") +
    theme(panel.grid = element_blank(), 
          axis.text.x = element_text(angle = 90, vjust = 0.5, hjust = 1),
          panel.background = element_rect(fill = "gray"),
          plot.title = element_text(size=22),
          axis.text = element_text(size = 18),
          axis.title = element_text(size = 22))
  return(p00)
}