% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cluster_expectationMaximization.R
\name{cluster_expectationMaximization}
\alias{cluster_expectationMaximization}
\title{A class to perform Expectation-Maximization clustering on sequential data for Process Mining issues}
\usage{
cluster_expectationMaximization()
}
\description{
This class performs sequence clustering on an event-log with the Expectation-Maximization (EM) algorithm. The public methods are:
               \itemize{
               \item \code{cluster_expectationMaximization( ) } is the constructor of the class
               \item \code{loadDataset( ) } loads data taken from a \code{dataLoader::getData()} method, into a \code{cluster_expectationMaximization()} object
               \item \code{calculateClusters( ) } performs the actual clustering computation on the previously loaded dataset
               \item \code{getClusters( ) } returns the clusters computed by the \code{cluster_expectationMaximization::calculateClusters()} method
               \item \code{getClusterStats( )} returns informations about the clustering result (i.e. support, between-cluster distance, within-cluster mean distance and standard deviation)
               \item \code{getClusterLog( )} returns informations about the clustering computation itself (i.e. iterations needed to converge, centroids value after each iteration)
               }
               In order to better undestand the use of such methods, please visit: www.pminer.info
               
Parameters for \code{cluster_expectationMaximization::calculateClusters()} method are:
  \itemize{
   \item \code{num } the number of clusters it has to generate
   \item \code{typeOfModel } the name of the Process Mining model it has to use to generate the space (up to now, only the default \code{"firstOrdermarkovModel"} is provided)
  }
}
\examples{
\dontrun{

# create a Loader
obj.L<-dataLoader();   # create a Loader

# Load a .csv using "DES" and "ID" as column names to indicate events
# and Patient's ID
obj.L$load.csv(nomeFile = "./otherFiles/test_02.csv",
IDName = "ID",EVENTName = "DES", dateColumnName = "DATA")

# now create an object cluster_expectationMaximization
obj.clEM<- cluster_expectationMaximization();

# load the data into logInspector object
obj.clEM$loadDataset( obj.L$getData() );

# perform clustering computation
obj.clEM$calculateClusters(num = 5, typeOfModel = "firstOrderMarkovModel");

# get calculated clusters 
a <- obj.clEM$getClusters();

# get informations about performance of clusters
b <- obj.clEM$getClusterStats();

# get log of each iteration of the algorithm
d <- obj.clEM$getClusterLog();
}
}

