% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrappingFunctions.R
\name{PM.loadDataset}
\alias{PM.loadDataset}
\title{Load a dataset into a Process Mining model}
\usage{
PM.loadDataset(PM.obj, dataList)
}
\arguments{
\item{PM.obj}{an Process Mining model previously instantiated via the appropriate class (in example \code{alphaAlgorithm()}  or \code{firstOrderMarkovModel()}) or \code{AA.builder();} wrapper function}

\item{dataList}{a \code{dataList} structure, returned by a \code{dataLoader::getData()} method}
}
\description{
This function wraps the \code{<object>::loadDataset( ... ) } method and loads a dataset into a Process Mining model
}
\examples{
\dontrun{
# Instantiate a'firstOrderMarkovModel' model
obj.LD<-LD.builder()

# Load a CSV into the loader
LD.load.csv(loader.obj = obj.LD ,nomeFile = "../csv/dati_retto.csv",
                  IDName = "CODICE_SANITARIO_ADT",EVENTName = "CAT1")

# Instantiate a PM model
obj.PM <-PM.builder(kindOfObject = "firstOrderMarkovModel")

# Load the previously loaded csv into the PM model
PM.loadDataset(PM.obj = obj.PM,dataList = LD.getData(loader.obj = obj.LD))
}
}

