% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/max_distance_measure.R
\name{max_distance_measure}
\alias{max_distance_measure}
\title{Minimize the distance in measure criterion}
\usage{
max_distance_measure(lower, upper, optimcontrol = NULL, batchsize,
  integration.param, T, model)
}
\arguments{
\item{lower}{a \eqn{d} dimensional vector containing the lower bounds for the optimization}

\item{upper}{a \eqn{d} dimensional vector containing the upper bounds for the optimization}

\item{optimcontrol}{the parameters for the optimization, see \link[KrigInv]{max_sur_parallel} for more details.}

\item{batchsize}{number of simulations points to find}

\item{integration.param}{the parameters for the integration of the criterion, see \link[KrigInv]{max_sur_parallel} for more details.}

\item{T}{threshold value}

\item{model}{a km model}
}
\value{
A list containing \itemize{
        \item \code{par} a matrix \code{batchsize*d} containing the optimal points
        \item \code{value} if \code{optimcontrol$optim.option!=1} and \code{optimcontrol$method=="genoud"} (default options) a vector of length \code{batchsize} containing the optimum at each step
        otherwise the value of the criterion at the optimum.
}
}
\description{
Optimizes the distance in measure criterion.
}
\references{
Azzimonti D. F., Bect J., Chevalier C. and Ginsbourger D. (2016). Quantifying uncertainties on excursion sets under a Gaussian random field prior. SIAM/ASA Journal on Uncertainty Quantification, 4(1):850–874.

Azzimonti, D. (2016). Contributions to Bayesian set estimation relying on random field priors. PhD thesis, University of Bern.
}
