% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_layer.R
\name{get_layer}
\alias{get_layer}
\title{Get specified spatial layer from OxCOVID19 Database}
\usage{
get_layer(con, layer = "administrative_division", ccode, adm)
}
\arguments{
\item{con}{Connection to \strong{OxCOVID19 Database}. This can be specified using
the \code{\link[=connect_oxcovid19]{connect_oxcovid19()}} function.}

\item{layer}{Name of spatial layer available in \strong{OxCOVID19 Database}.
Currently, only \code{administrative_division} is a spatial layer.}

\item{ccode}{Three character ISO country code for required country
layers.}

\item{adm}{Numeric value for administrative level layer required. Possible
values are 0 for whole country, 1 for administrative level 1, 2 for
administrative level 2 and 3 for administrative level 3. Default is 0 for
country borders.}
}
\value{
An object of \code{sf} class of the specified spatial layer
}
\description{
Get specified spatial layer from OxCOVID19 Database
}
\examples{
con <- connect_oxcovid19()
get_layer(con = con, ccode = "CHN", adm = 1)

}
\author{
Ernest Guevarra
}
