% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/owid_get_metadata.R
\name{owid_get_metadata}
\alias{owid_get_metadata}
\title{Download metadata from Our World in Data}
\usage{
owid_get_metadata(chart_id = NULL, url = NULL)
}
\arguments{
\item{chart_id}{Character string specifying the chart identifier
(e.g., "life-expectancy"). Not required if \code{url} is provided.}

\item{url}{Direct URL to an OWID chart. If provided, \code{chart_id} is ignored.}
}
\value{
A list containing the requested OWID metadata.
}
\description{
Retrieves the metadata for a data set from Our World in Data (OWID) by
specifying a chart identifier or direct URL.
}
\examples{
\dontshow{if (curl::has_internet()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
# Download metadata using a data set
owid_get_metadata("life-expectancy")

# Download metadata using an url
owid_get_metadata(
 url = "https://ourworldindata.org/grapher/civil-liberties-score-fh"
)
}
\dontshow{\}) # examplesIf}
}
