% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/args.R
\name{arglist_parse}
\alias{arglist_parse}
\title{Normalise arguments for docker container}
\usage{
arglist_parse(
  arglist,
  keyvals_to_drop = NULL,
  vals_to_drop = NULL,
  normalise_paths = TRUE
)
}
\arguments{
\item{arglist}{Arguments as character vector}

\item{keyvals_to_drop}{Argument keys to drop, e.g. -wd.}

\item{vals_to_drop}{Specific values to drop, e.g. --verbose.}

\item{normalise_paths}{Reduce paths to basenames? Default, TRUE.}
}
\value{
Character vector
}
\description{
Utility function for parsing the arguments provided by a user.
Drop any specified key:value pairs with \code{keyvals_to_drop} or drop any
specific values \code{vals_to_drop}. With \code{normalise_paths} as TRUE,
all filepaths in the arglist will be converted to basenames.
}
\details{
It is important the file paths are normalised, because they will
not be available to the Docker container. The only files available will
be those that have been transferred to the container as determined through
the \code{\link{outsider_init}}. These files will be located in the
same directory as where the function is called and require no absolute
file path.
}
\examples{
library(outsider.base)
wd <- file.path(tempdir(), 'results')
dir.create(wd)
arglist <- c('-a', 10, '-b', 'model2', '-wd', wd, '--unwanted')
# drop unwanted key:value pairs
(arglist_parse(arglist = arglist, keyvals_to_drop = '-wd',
               normalise_paths = FALSE))
# drop unwanted argument values
(arglist_parse(arglist = arglist, vals_to_drop = '--unwanted',
               normalise_paths = FALSE))
# make paths relative, necessary for Docker:
#   paths must be relative to the working directory in the container
(arglist_parse(arglist = arglist, normalise_paths = TRUE))


# clean-up
unlink(wd, recursive = TRUE)
}
