#' Dengue on the island of Fais, Micronesia, 2011
#'
#' These data describe incidence of clincal cases of Dengue
#' on the island of Fais, Micronesia.
#'
#' @docType data
#'
#' @format {
#' A data frame with 57 rows and 3 columns
#' \describe{
#'   \item{onset_date}{Date}
#'   \item{nr}{Days after starting date}
#'   \item{value}{Number of cases}
#' }
#'
#' The data on Dengue incidence reported by Funk et al. (2016) cover the period
#' from 2011-09-15 to 2012-02-14, over which time a total of 157 clinical cases
#' were reported among 294 residents. The first reported case is thought to be
#' the index case. The population of Fais is concentrated in a single population
#' centre, and is thought to have been immunologically naive at the time of
#' infection.
#'
#' }
#' @rdname dengue_fais_2011
#'
#' @author Data from Funk et al. (2016), provided by Sebastian Funk (github.com/sbnfunk).
#' Transfer to R and documentation by Finlay Campbell (\email{f.campbell15@@imperial.ac.uk}).
#'
#' @source Funk et al. (2016)
#'
#' @references
#'
#' S. Funk, et al. 2016. Comparative Analysis of Dengue and Zika Outbreaks Reveals
#' Differences by Setting and Virus. PLOS Neglected Tropical Diseases, 10(12),
#' e0005173. http://doi.org/10.1371/journal.pntd.0005173
#'
#'
#' @examples
#' ## show first few weeks of Dengue incidence
#' head(dengue_fais_2011)
#'
"dengue_fais_2011"
