% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_config.R
\name{create_config}
\alias{create_config}
\alias{print.outbreaker_config}
\title{Set and check parameter settings of outbreaker}
\usage{
create_config(..., data = NULL)

\method{print}{outbreaker_config}(x, ...)
}
\arguments{
\item{...}{further arguments to be passed to other methods}

\item{data}{an optional list of data items as returned by
\code{outbreaker_data}; if provided, this allows for further checks of
the outbreaker setings.}

\item{x}{an \code{outbreaker_config} object as returned by \code{create_config}.}
}
\description{
This function defines settings for outbreaker.  It takes a list of named
items as input, performs various checks, set defaults where arguments are
missing, and return a correct list of settings. If no input is given, it
returns the default settings.
}
\details{
Acceptables arguments for ... are:

\describe{

\item{init_tree}{the tree used to initialize the MCMC. Can be either a
character string indicating how this tree should be computed, or a vector of
integers corresponding to the tree itself, where the i-th value corresponds
to the index of the ancestor of 'i' (i.e., \code{init.tree[i]} is the
ancestor of case \code{i}). Accepted character strings are "seqTrack" (uses
seqTrack algorithm to generate the initial tree - see function
\code{seqTrack} in the package \code{adegenet}), "random" (ancestor randomly
selected from preceding cases), and "star" (all cases coalesce to the first
case).  Note that for SeqTrack, all cases should have been sequenced.}

\item{init_alpha}{a vector of integers indicating the initial values of
alpha, where the i-th value indicates the ancestor of case 'i'; defaults to
\code{NULL}, in which ancestries are defined from \code{init_tree}.}

\item{init_kappa}{a (recycled) vector of integers indicating the initial
values of kappa; defaults to 1.}

\item{init_t_inf}{a vector of integers indicating the initial values of
\code{t_inf}, i.e. dates of infection; defaults to \code{NULL}, in which case
the most likely \code{t_inf} will be determined from the delay to
reporting/symptoms distribution, and the dates of reporting/symptoms,
provided in \code{data}.}

\item{init_mu}{initial value for the mutation rates}

\item{init_pi}{initial value for the reporting probability}

\item{init_eps}{initial value for the contact reporting coverage}

\item{init_lambda}{initial value for the non-infectious contact rate}

\item{n_iter}{an integer indicating the number of iterations in the MCMC,
including the burnin period}

\item{move_alpha}{a vector of logicals indicating, for each case, if the
ancestry should be estimated ('moved' in the MCMC), or not, defaulting to
TRUE; the vector is recycled if needed.}

\item{move_t_inf}{a vector of logicals indicating, for each case, if the
dates of infection should be estimated ('moved' in the MCMC), or not,
defaulting to TRUE; the vector is recycled if needed.}

\item{move_mu}{a logical indicating whether the mutation rates
should be estimated ('moved' in the MCMC), or not, all defaulting to TRUE.}

\item{move_pi}{a logical indicating whether the reporting probability
should be estimated ('moved' in the MCMC), or not, all defaulting to TRUE.}

\item{move_eps}{a logical indicating whether the contact reporting coverage
should be estimated ('moved' in the MCMC), or not at all, defaulting to
TRUE.}

\item{move_lambda}{a logical indicating whether the non-infectious contact
rate should be estimated ('moved' in the MCMC), or not at all, defaulting to
TRUE.}

\item{move_kappa}{a logical indicating whether the number of generations
between two successive cases should be estimated ('moved' in the MCMC), or
not, all defaulting to TRUE.}

\item{move_pi}{a logical indicating whether the reporting probability
should be estimated ('moved' in the MCMC), or not, all defaulting to TRUE.}

\item{n_iter}{the number of iterations of the MCMC}

\item{sample_every}{the frequency at which MCMC samples are retained for the
output}

\item{sd_mu}{the standard deviation for the Normal proposal for the mutation
rates}

\item{sd_pi}{the standard deviation for the Normal proposal for the reporting
probability}

\item{sd_eps}{the standard deviation for the Normal proposal for the
contact reporting coverage}

\item{sd_lambda}{the standard deviation for the Normal proposal for the
non-infectious contact rate}

\item{prop_alpha_move}{the proportion of ancestries to move at each iteration
of the MCMC}

\item{prop_t_inf_move}{the proportion of infection dates to move at each
iteration of the MCMC}
\item{batch_size}{the size of the batch of random number pre-generated}

\item{paranoid}{a logical indicating if the paranoid mode should be used;
this mode is used for performing additional tests during outbreaker; it makes
computations substantially slower and is mostly used for debugging purposes.}

\item{min_date}{earliest infection date possible, expressed as days since the
first sampling}

\item{max_kappa}{an integer indicating the largest number of generations
between any two linked cases; defaults to 5}

\item{prior_mu}{a numeric value indicating the rate of the exponential prior
for the mutation rate 'mu'}

\item{prior_pi}{a numeric vector of length 2 indicating the first and second
parameter of the beta prior for the reporting probability 'pi'}

\item{prior_eps}{a numeric vector of length 2 indicating the first and second
parameter of the beta prior for the contact reporting coverage 'eps'}

\item{prior_lambda}{a numeric vector of length 2 indicating the first and
second parameter of the beta prior for the non-infectious contact rate
'lambda'}

}
}
\examples{
## see default settings
create_config()

## change defaults
create_config(move_alpha = FALSE, n_iter = 2e5, sample_every = 1000)



}
\seealso{
\code{\link{outbreaker_data}} a to check and process data for outbreaker
}
\author{
Thibaut Jombart (\email{thibautjombart@gmail.com})
}
