% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ouchtree.R
\name{ouchtree}
\alias{ouchtree}
\alias{ouchtree-class}
\title{Phylogenetic tree object in 'ouch' format.}
\usage{
ouchtree(nodes, ancestors, times, labels = as.character(nodes))
}
\arguments{
\item{nodes}{A character vector giving the name of each node.
These are used internally and must be unique.}

\item{ancestors}{Specification of the topology of the phylogenetic tree.
This is in the form of a character vector specifying the name
(as given in the \code{nodes} argument)
of the immediate ancestor of each node.
In particular, the i-th name is that of the ancestor of the i-th node.
The root node is distinguished by having no ancestor (i.e., \code{NA}).}

\item{times}{A vector of nonnegative numbers, one per node in the tree,
specifying the time at which each node is located.
Time should be increasing from the root node to the terminal twigs.}

\item{labels}{Optional vector of node labels.
These will be used in plots to label nodes.
It is not necessary that these be unique.}
}
\description{
An object containing a phylogenetic tree in a form suitable for using \pkg{ouch} methods.
}
\details{
\code{ouchtree} creates an \code{ouchtree} object.
This contains the topology, branch times, and epochs.
It also (optionally) holds names of taxa for display purposes.
}
\examples{
tree <- with(
  bimac,
  ouchtree(nodes=node,ancestors=ancestor,times=time,labels=species)
)
tree

plot(tree)
plot(tree,node.names=TRUE)
}
\seealso{
\code{ouchtree}, \code{ape2ouch}, \code{brown}, \code{hansen}
}
\author{
Aaron A. King
}
\keyword{models}
