#' add_osm_objects
#'
#' Adds layers of spatial objects (polygons, lines, or points generated by
#' extract_osm_objects ()) to a graphics object initialised with
#' plot_osm_basemap().
#'
#' @param obj an sp SPDF or SLDF (list of polygons or lines) returned by
#' extract_osm_objects ()
#' @param col colour of polygons or lines (default = 'gray40')
#' @param border border colour of polygons
#' @param ... other parameters to be passed to polygons (such as border),
#' lines (such as lwd, lty), or points (such as pch, cex)
#' @return nothing (adds to graphics.device opened with plot_osm_basemap())

add_osm_objects <- function (obj=obj, col='gray40', border=NA, ...)
{
    if (is.null (dev.list ()))
        stop ('group.osm.objects can only be called after plot.osm.basemap')

    if (class (obj) == 'SpatialPolygonsDataFrame')
    {
        plotfunPts <- function (i, col=col, border=border, ...) 
        {
            xy <- slot (slot (i, 'Polygons') [[1]], 'coords')
            polypath (xy, col=col, border=border, ...)
        }
        junk <- lapply (slot (obj, 'polygons'), function (i)
                        plotfunPts (i, col=col, border=border, ...))
    } else if (class (obj) == 'SpatialLinesDataFrame')
    {
        plotfunLines <- function (i, col=col, ...) 
        {
            xy <- slot (slot (i, 'Lines') [[1]], 'coords')
            lines (xy, col=col, ...)
        }
        junk <- lapply (slot (obj, 'lines'), function (i)
                        plotfunLines (i, col=col, ...))
    } else if (class (obj) == 'SpatialPointsDataFrame')
    {
        xy <- slot (obj, 'coords')
        points (xy[,1], xy[,2], col=col, ...)
    }
}

