/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.osmose.ui;

import fr.ird.osmose.Osmose;
import fr.ird.osmose.School;
import fr.ird.osmose.util.SimulationLinker;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.geom.Ellipse2D;
import java.awt.image.BufferedImage;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public class SimulationUI
extends SimulationLinker {
    private static final int SLEEP = 1000;
    private static final int height = 1600;
    private int width;
    private static int hi;
    private static int wi;
    private static double latmin;
    private static double latmax;
    private static double lonmin;
    private static double lonmax;
    private static BufferedImage background;
    private static RenderingHints hints;
    private static final double ONE_DEG_LATITUDE_IN_METER = 111138.0;
    private boolean isGridVisible = false;
    private JPanel panel = new JPanel(){

        @Override
        public void paintComponent(Graphics g) {
            int h = this.getHeight();
            int w = this.getWidth();
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHints(hints);
            g2.clearRect(0, 0, w, h);
            if (hi != h || wi != w) {
                SimulationUI.this.drawBackground(g2, w, h);
                hi = h;
                wi = w;
            }
            g2.drawImage((Image)background, 0, 0, this);
            if (SimulationUI.this.getSchoolSet() != null) {
                SchoolUI schoolUI = new SchoolUI();
                for (School school : SimulationUI.this.getSchoolSet().getPresentSchools()) {
                    schoolUI.draw(school, w, h);
                    g2.setColor(schoolUI.getColor(school.getSpeciesIndex()));
                    g2.fill(schoolUI);
                }
            }
        }

        @Override
        public int getWidth() {
            return SimulationUI.this.width;
        }

        @Override
        public int getHeight() {
            return 1600;
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(SimulationUI.this.width, 1600);
        }
    };
    private static JFrame frameUI;
    private static SimulationUI simulationUI;

    public SimulationUI() {
        super(0);
        hi = -1;
        wi = -1;
        hints = new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        hints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        hints.put(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        this.init();
    }

    private static void createUI() {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    frameUI = new JFrame("Osmose grid");
                    simulationUI = new SimulationUI();
                    frameUI.setDefaultCloseOperation(3);
                    JScrollPane scrollPane = new JScrollPane();
                    scrollPane.setViewportView(simulationUI.getPanel());
                    frameUI.getContentPane().add((Component)scrollPane, "Center");
                    frameUI.setExtendedState(6);
                    scrollPane.setPreferredSize(simulationUI.getPanel().getSize());
                    scrollPane.revalidate();
                    frameUI.pack();
                    frameUI.setLocationRelativeTo(null);
                    simulationUI.setGridVisible(true);
                    frameUI.setVisible(true);
                }
            });
        }
        catch (InterruptedException ex) {
            Logger.getLogger(SimulationUI.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InvocationTargetException ex) {
            Logger.getLogger(SimulationUI.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static void step(final int year, final int iStepYear) {
        if (null == frameUI) {
            SimulationUI.createUI();
        }
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    frameUI.setTitle("Year " + year + " Step " + iStepYear);
                    simulationUI.getPanel().repaint();
                }
            });
        }
        catch (InterruptedException ex) {
            Logger.getLogger(SimulationUI.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InvocationTargetException ex) {
            Logger.getLogger(SimulationUI.class.getName()).log(Level.SEVERE, null, ex);
        }
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(SimulationUI.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public JPanel getPanel() {
        return this.panel;
    }

    private void drawBackground(Graphics2D g2, int w, int h) {
        background = g2.getDeviceConfiguration().createCompatibleImage(w, h);
        Graphics2D graphic = background.createGraphics();
        graphic.setColor(new Color(223, 212, 200));
        graphic.fillRect(0, 0, w, h);
        CellUI cell = new CellUI();
        int j = this.getGrid().get_ny() - 1;
        while (j-- > 0) {
            int i = this.getGrid().get_nx() - 1;
            while (i-- > 0) {
                cell.draw(i, j, w, h);
                graphic.setColor(cell.getColor(i, j));
                graphic.fillPolygon(cell);
                if (!this.isGridVisible) continue;
                graphic.setColor(Color.WHITE);
                graphic.drawPolygon(cell);
            }
        }
    }

    public void setGridVisible(boolean visible) {
        this.isGridVisible = visible;
        this.repaintBackground();
    }

    private void repaintBackground() {
        hi = -1;
        wi = -1;
        this.panel.repaint();
    }

    private int[] grid2Screen(double xgrid, double ygrid, int w, int h) {
        int[] point = new int[2];
        int igrid = (int)xgrid;
        int jgrid = (int)ygrid;
        double dx = xgrid - (double)igrid;
        double dy = ygrid - (double)jgrid;
        double[] p1 = this.grid2Screen(igrid, jgrid, w, h);
        double[] p2 = this.grid2Screen(igrid + 1, jgrid, w, h);
        double[] p3 = this.grid2Screen(igrid, jgrid + 1, w, h);
        double[] p4 = this.grid2Screen(igrid + 1, jgrid + 1, w, h);
        for (int n = 0; n < 2; ++n) {
            double interp = (1.0 - dx) * (1.0 - dy) * p1[n] + dx * (1.0 - dy) * p2[n] + (1.0 - dx) * dy * p3[n] + dx * dy * p4[n];
            point[n] = Double.isNaN(interp) ? -1 : (int)interp;
        }
        return point;
    }

    private double[] grid2Screen(int igrid, int jgrid, int w, int h) {
        double[] point = new double[]{(double)w * (((double)this.getGrid().getCell(igrid, jgrid).getLon() - lonmin) / Math.abs(lonmax - lonmin)), (double)h * (1.0 - ((double)this.getGrid().getCell(igrid, jgrid).getLat() - latmin) / Math.abs(latmax - latmin))};
        return point;
    }

    private void init() {
        latmin = this.getGrid().getLatMin();
        latmax = this.getGrid().getLatMax();
        lonmin = this.getGrid().getLongMin();
        lonmax = this.getGrid().getLongMax();
        double avgLat = 0.5 * (latmin + latmax);
        double dlon = Math.abs(lonmax - lonmin) * 111138.0 * Math.cos(Math.PI * avgLat / 180.0);
        double dlat = Math.abs(latmax - latmin) * 111138.0;
        double ratio = dlon / dlat;
        this.width = (int)(1600.0 * ratio);
    }

    public static double geodesicDistance(double lat1, double lon1, double lat2, double lon2) {
        double lat1_rad = Math.PI * lat1 / 180.0;
        double lat2_rad = Math.PI * lat2 / 180.0;
        double lon1_rad = Math.PI * lon1 / 180.0;
        double lon2_rad = Math.PI * lon2 / 180.0;
        double d = 1.2734E7 * Math.asin(Math.sqrt(Math.pow(Math.sin((lat2_rad - lat1_rad) / 2.0), 2.0) + Math.cos(lat1_rad) * Math.cos(lat2_rad) * Math.pow(Math.sin((lon2_rad - lon1_rad) / 2.0), 2.0)));
        return d;
    }

    public static Osmose getOsmose() {
        return Osmose.getInstance();
    }

    static {
        hints = null;
    }

    private class SchoolUI
    extends Ellipse2D.Double {
        private Color[] colors = new Color[]{Color.BLUE, Color.GRAY, Color.MAGENTA, Color.BLUE, Color.PINK, Color.ORANGE, Color.RED, Color.WHITE, Color.YELLOW, Color.GREEN, Color.CYAN, Color.BLACK};

        private SchoolUI() {
        }

        private void draw(School school, int w, int h) {
            double xs = (double)school.getCell().get_igrid() + Math.random() - 0.5;
            xs = Math.min(xs, (double)(SimulationUI.this.getGrid().get_nx() - 2));
            double ys = (double)school.getCell().get_jgrid() + Math.random() - 0.5;
            ys = Math.min(ys, (double)(SimulationUI.this.getGrid().get_ny() - 2));
            int[] corner = SimulationUI.this.grid2Screen(xs, ys, w, h);
            double length = school.getLength() / 4.0f;
            length = Math.min(Math.max(length, 1.0), 50.0);
            this.setFrame((double)corner[0] - 0.5 * length, (double)corner[1] - 1.5, length, Math.min(length, 3.0));
        }

        private Color getColor(int iSpec) {
            return this.colors[iSpec];
        }
    }

    private class CellUI
    extends Polygon {
        private int[][] points = new int[4][2];

        public void draw(int i, int j, int w, int h) {
            this.reset();
            this.points[0] = SimulationUI.this.grid2Screen((float)i - 0.5f, (float)j - 0.5f, w, h);
            this.points[1] = SimulationUI.this.grid2Screen((float)i + 0.5f, (float)j - 0.5f, w, h);
            this.points[2] = SimulationUI.this.grid2Screen((float)i + 0.5f, (float)j + 0.5f, w, h);
            this.points[3] = SimulationUI.this.grid2Screen((float)i - 0.5f, (float)j + 0.5f, w, h);
            for (int n = 0; n < 4; ++n) {
                if (this.points[n][0] < 0 || this.points[n][1] < 0) {
                    this.reset();
                    return;
                }
                this.addPoint(this.points[n][0], this.points[n][1]);
            }
        }

        private Color getColor(int i, int j) {
            if (SimulationUI.this.getGrid().getCell(i, j).isLand()) {
                return Color.DARK_GRAY;
            }
            return new Color(150, 150, 255);
        }
    }
}

