% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/osm-extract.R
\name{osm_lines}
\alias{osm_lines}
\title{Extract all \code{osm_lines} from an osmdata object}
\usage{
osm_lines(dat, id)
}
\arguments{
\item{dat}{An object of class \link{osmdata}}

\item{id}{OSM identification of one or more objects for which lines are to be
extracted}
}
\value{
An \pkg{sf} Simple Features Collection of linestrings
}
\description{
If \code{id} is of a point object, \code{osm_lines} will return all lines
containing that point. If \code{id} is of a line or polygon object,
\code{osm_lines} will return all lines which intersect the given line or
polygon.
}
\examples{
\dontrun{
dat <- opq ("hengelo nl") \%>\% add_osm_feature (key="highway") \%>\%
     osmdata_sf ()
bus <- dat$osm_points [which (dat$osm_points$highway == "bus_stop"),] \%>\%
        rownames () # all OSM IDs of bus stops
osm_lines (dat, bus) # all highways containing bus stops

# All lines which intersect with Piccadilly Circus in London, UK
dat <- opq ("Fitzrovia London") \%>\% add_osm_feature (key="highway") \%>\%
    osmdata_sf ()
i <- which (dat$osm_polygons$name == "Piccadilly Circus")
id <- rownames (dat$osm_polygons [i,])
osm_lines (dat, id)
}
}
