% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connectors.R
\name{license_by_id}
\alias{license_by_id}
\title{Get license metadata by license ID}
\usage{
license_by_id(license_ids, ...)
}
\arguments{
\item{license_ids}{the ID (or IDs! It's vectorised!) to retrieve metadata for.
IDs can be extracted from existing data with \code{\link{extract_id}}.}

\item{...}{arguments to pass to httr's GET.}
}
\value{
a list of licenses and their metadata (themselves in the form of
lists) which can be provided to other functions such as \code{\link{license_text}}
}
\description{
\code{license_by_id} retrieves the metadata for a set of licenses
with particular license IDs.
}
\examples{
# Get the GPL's metadata
gpl_2_metadata <- license_by_id("GPL-2.0")

}
\seealso{
\code{\link{license_text}}, which can consume the results of this
function, and \code{\link{extract_id}}, to retrieve the IDs, as well as
\code{\link{license_by_keyword}} for an alternate
way of looking up particular licenses.
}

