% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/funcsS4.R
\docType{methods}
\name{coef,oscar-method}
\alias{coef,oscar-method}
\alias{predict,oscar-method}
\alias{plot,oscar-method}
\title{Extract coefficients of oscar-objects}
\usage{
\S4method{coef}{oscar}(object, k)

\S4method{predict}{oscar}(
  object,
  k,
  type = c("response", "link", "nonzero", "coefficients", "label"),
  newdata = object@x
)

\S4method{plot}{oscar}(x, y, k = 1:x@kmax, add = FALSE, intercept = FALSE, ...)
}
\arguments{
\item{object}{Fit oscar S4-object}

\item{k}{Vector of cardinality 'k' values}

\item{type}{Type of prediction; valid values are 'response', 'link', 'nonzero', 'coefficients', or 'label'}

\item{newdata}{Data to predict on; if no alternate is supplied, the function uses the original 'x' data matrix used to fit object}

\item{x}{Values on x-axis}

\item{y}{Values on y-axis}

\item{add}{Should the plot be added on top of an existing plot (if FALSE, create a new graphics device), Default: FALSE}

\item{intercept}{Should model intercept be plotted, Default: FALSE}

\item{...}{Additional parameters passed on to the points-function drawing lines as a function of cardinality}
}
\value{
Vector of model coefficient values at given cardinality 'k'

A vector of coefficient predictions at the specificied cardinality 'k' with a format depending on the supplied 'type' parameter

Override default plot function with no return but instead tailor suitable graphics plotting
}
\description{
Extract coefficients of oscar-objects

Prediction based on oscar-objects

Plot oscar-coefficients as a function of k and override default plot generic
}
