% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kernel_weight.r
\name{kernel_weight}
\alias{kernel_weight}
\title{Kernel Weight}
\usage{
kernel_weight(x1, x2, kernel = "gaussian", dist = "euclidean")
}
\arguments{
\item{x1}{First data matrix}

\item{x2}{Second data matrix}

\item{kernel}{The kernel function, currently only using Gaussian kernel.}

\item{dist}{The distance metric, currently only using the Euclidean
distance.}
}
\value{
A distance matrix, with its (i, j)th element being the kernel weights for
the \emph{i} th row of \code{X1} jth row of \code{X2}.
}
\description{
Calculate the Gaussian kernel weights between rows of \code{X1} and rows of \code{X2}.
}
\examples{
# two matrices
set.seed(1)
x1 <- matrix(rnorm(10), 5, 2)
x2 <- matrix(rnorm(6), 3, 2)
kernel_weight(x1, x2)
}
