% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distance.r
\name{distance}
\alias{distance}
\title{distance correlation}
\usage{
distance(s1, s2, type = "dist", x = NULL)
}
\arguments{
\item{s1}{first space}

\item{s2}{second space}

\item{type}{type of distance measures: "dist" (default), "trace", "canonical" or "sine"}

\item{x}{the covariate values, for canonical correlation only}
}
\value{
The distance between \code{s1} and \code{s2}.
}
\description{
Calculate the distance correlation between two linear spaces
}
\examples{
# two spaces
failEDR = as.matrix(cbind(c(1, 1, 0, 0, 0, 0),
                          c(0, 0, 1, -1, 0, 0)))
B = as.matrix(cbind(c(0.1, 1.1, 0, 0, 0, 0),
                    c(0, 0, 1.1, -0.9, 0, 0)))

distance(failEDR, B, "dist")
distance(failEDR, B, "trace")

N=300
P=6
dataX = matrix(rnorm(N*P), N, P)
distance(failEDR, B, "canonical", dataX)
}
