% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/afniS4.R
\docType{data}
\name{convert.scene}
\alias{convert.scene}
\title{Convert AFNI data codes}
\usage{
convert.scene(scene.data, typestring)
}
\arguments{
\item{scene.data}{defines data type.}

\item{typestring}{defines whether func or anat data.}
}
\value{
A character string.
}
\description{
Codes that appear in the AFNI header are mapped to meaningful character
strings.
}
\details{
\code{switch} statements are used to map a numeric code to the appropriate
string.
}
\examples{

## 4 = CT for anatomic data
convert.scene(4, "3DIM_HEAD_ANAT")
}
\author{
Karsten Tabelow \email{karsten.tabelow@wias-berlin.de}
}
\references{
AFNI\cr
\url{http://afni.nimh.nih.gov/pub/dist/src/README.attributes}
}
\seealso{
\code{\link{convert.datatype.anlz}},
\code{\link{convert.orient.anlz}}
}
\keyword{misc}

