% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/convert_nifti.R
\name{Convert NIfTI Codes}
\alias{Convert NIfTI Codes}
\alias{convert.bitpix}
\alias{convert.datatype}
\alias{convert.form}
\alias{convert.intent}
\alias{convert.slice}
\alias{convert.units}
\title{Convert NIfTI Codes}
\usage{
convert.bitpix(bitpix = NULL)

convert.datatype(datatype.code = NULL)

convert.intent(intent.code = NULL)

convert.form(form.code)

convert.units(units, inverse = FALSE)

convert.slice(slice.code)
}
\arguments{
\item{bitpix}{is the bit-per-pixel code.}

\item{datatype.code}{defines data type.}

\item{intent.code}{is the NIfTI intent code.}

\item{form.code}{is the \eqn{(x,y,z)} coordinate system.}

\item{units}{is the units of pixdim[1..4].}

\item{inverse}{is a logical value that denotes the direction of unit
conversion.}

\item{slice.code}{is the slice timing order.}
}
\value{
A character string.
}
\description{
Codes that appear in the ANALYZE header are mapped to
meaningful chartacter strings.
}
\details{
\code{switch} statements are used to map a numeric code to the
appropriate string.
}
\examples{
##  4 = SIGNED_SHORT
convert.datatype.anlz(4)
## 16 = FLOAT
convert.datatype.anlz(16)
##  2 = "saggital unflipped"
convert.orient.anlz(2)
##  4 = "coronal flipped"
convert.orient.anlz(4)
}
\author{
Brandon Whitcher \email{bwhitcher@gmail.com}
}
\references{
Neuroimaging Informatics Technology Initiative (NIfTI)\cr
\url{http://nifti.nimh.nih.gov/}
}

