% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/griis.R
\name{griis}
\alias{griis}
\title{Check invasive species status for a species from GRIIS database}
\usage{
griis(name = NULL, impacts = NULL, verified = NULL, country = NULL,
  kindom = NULL, type = NULL, ...)
}
\arguments{
\item{name}{character; a string with the scientific species name in the
form of "Genus species". Default is NULL: return all records.}

\item{impacts}{character; "Yes" for returning only records with impacts.
Default to NULL: return all records.}

\item{verified}{character; "Yes" for returning only verified records.
Default to NULL: return all records.}

\item{country}{character containing a valid name of a country for which to
filter the results. Default to NULL: return all records.}

\item{kindom}{character containing a valid name of a kindom (plantae,
animalia, fungi, protozoa, chromista, others, ) for which to filter the
results. Default to NULL: return all records.}

\item{type}{character containing a valid name of a environment type
(terrestrial, freshwater, marine, brackish, host) for which to filter
the results. Default to NULL: return all records.}

\item{...}{curl options passed on to \code{\link[crul]{HttpClient}}}
}
\value{
A data.frame with species names, country where recorded,
origin and source among other fields.
}
\description{
This retrieves information from GRIIS (http://www.griis.org/)
and returns all the queried records. As other functions in this package, the
function is as good as the database is.
}
\note{
It seems as 'name' overrides 'kindom', which means records from a
a plant species will be returned even if kindom is set to animalia.
}
\examples{
\dontrun{
griis(name = "Carpobrotus edulis")
griis(name = "Carpobrotus edulis", country = "Portugal")
}

}
\author{
Ignasi Bartomeus \email{nacho.bartomeus@gmail.com}
}
