% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ore.R
\name{ore}
\alias{ore}
\alias{is_ore}
\alias{is.ore}
\alias{print.ore}
\title{Oniguruma regular expressions}
\usage{
ore(..., options = "", encoding = getOption("ore.encoding"),
  syntax = c("ruby", "fixed"))

is_ore(x)

\method{print}{ore}(x, ...)
}
\arguments{
\item{...}{One or more strings or dictionary labels, constituting a valid
regular expression after being concatenated together. Elements drawn from
the dictionary will be surrounded by parentheses, turning them into
groups. Note that backslashes should be doubled, to avoid them being
interpreted as character escapes by R. The \code{...} argument is ignored
by the \code{print} method.}

\item{options}{A string composed of characters indicating variations on the
usual interpretation of the regex. These may currently include \code{"i"}
for case-insensitive matching, and \code{"m"} for multiline matching (in
which case \code{"."} matches the newline character).}

\item{encoding}{A string specifying the encoding that matching will take
place in. The default is given by the \code{"ore.encoding"} option, which
is usually set automatically from the current locale when the package is
loaded, but can be modified if needed.}

\item{syntax}{The regular expression syntax being used. The default is
\code{"ruby"}, which reflects the syntax of the Ruby language, which is
very similar to that of Perl. An alternative is \code{"fixed"}, for
literal matching without special treatment of characters.}

\item{x}{An R object.}
}
\value{
The \code{ore} function returns the final pattern, with class
  \code{"ore"} and the following attributes:
  \describe{
    \item{.compiled}{A low-level pointer to the compiled version of the
      regular expression.}
    \item{options}{Options, copied from the argument of the same name.}
    \item{encoding}{The specified or detected encoding.}
    \item{syntax}{The specified syntax type.}
    \item{nGroups}{The number of groups in the pattern.}
    \item{groupNames}{Group names, if applicable.}
  }
  The \code{is_ore} function returns a logical vector indicating whether
  its argument represents an \code{"ore"} object.
}
\description{
Create, test for, and print objects of class \code{"ore"}, which represent
Oniguruma regular expressions. These are unit-length character vectors with
additional attributes, including a pointer to the compiled version.
}
\examples{
# This matches a positive or negative integer
ore("-?\\\\d+")

# This matches words of exactly four characters
ore("\\\\b\\\\w{4}\\\\b")
}
\seealso{
For full details of supported syntax, please see
\url{https://raw.githubusercontent.com/k-takata/Onigmo/master/doc/RE}. The
\code{\link[base]{regex}} page is also useful as a quick reference, since
PCRE (used by base R) and Oniguruma (used by \code{ore}) have similar
features. See \code{\link{ore_dict}} for details of the pattern dictionary.
}
