% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/dict.R
\name{ore.dict}
\alias{ore.dict}
\title{Get or set entries in the pattern dictionary}
\usage{
ore.dict(...)
}
\arguments{
\item{...}{One or more strings or dictionary keys. Unnamed, literal strings
will be returned unmodified, named strings will be added to the
dictionary, and unquoted names will be resolved using the dictionary.}
}
\value{
If no arguments are provided, the whole dictionary is returned.
  Otherwise the return value is a (possibly named) character vector of
  resolved strings.
}
\description{
This function allows the user to get or set entries in the pattern
dictionary, a library of regular expressions whose elements can be referred
to by name in \code{\link{ore}}, and therefore easily reused.
}
\examples{
# Literal strings are returned as-is
ore.dict("protocol")

# Named arguments are added to the dictionary
ore.dict(protocol="\\\\w+://")

# ... and can be retrieved by name
ore.dict(protocol)
}
\seealso{
\code{\link{ore}}, which passes its arguments through this function
}

