% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ord-tbl.r
\name{tbl_ord}
\alias{tbl_ord}
\alias{as_tbl_ord}
\alias{as_tbl_ord.tbl_ord}
\alias{make_tbl_ord}
\alias{is_tbl_ord}
\alias{is.tbl_ord}
\alias{valid_tbl_ord}
\alias{un_tbl_ord}
\title{A unified ordination object class}
\usage{
as_tbl_ord(x)

\method{as_tbl_ord}{tbl_ord}(x)

make_tbl_ord(rows = NULL, cols = NULL, ...)

is_tbl_ord(x)

is.tbl_ord(x)

valid_tbl_ord(x)

un_tbl_ord(x)
}
\arguments{
\item{x}{An ordination object.}

\item{rows, cols}{Matrices to be used as factors of a tbl_ord.}

\item{...}{Additional elements of a custom tbl_ord.}
}
\value{
A tbl_ord (\verb{as*()}, \verb{make*()}), an S3-class model object that can be
wrapped as one (\verb{un*()}), or a logical value (\verb{is*()}, \verb{value*()}).
}
\description{
These functions wrap ordination objects in the class \link{tbl_ord},
create tbl_ords directly from matrices, and test for the class and basic
structure.
}
\details{
The tbl_ord class wraps around a range of ordination classes, making
available a suite of ordination tools that specialize to each original object
class. These tools include \code{\link[=format]{format()}} and \code{\link[ggplot2:fortify]{ggplot2::fortify()}} methods, which
facilitate the \code{\link[=print]{print()}} method and the \code{\link[=ggbiplot]{ggbiplot()}} function.

No default method is provided for \code{as_tbl_ord()}, despite most defined
methods being equivalent (simply appending 'tbl_ord' to the vector of object
classes). This prevents objects for which other methods are not defined from
being re-classed as tbl_ords.

The function \code{make_tbl_ord()} creates a tbl_ord structured as a list of two
matrices, \code{u} and \code{v}, which must have the same number of columns and the
same column names.

\code{is_tbl_ord()} checks an object \code{x} for the tbl_ord class; \code{valid_tbl_ord()}
additionally checks for consistency between \code{recover_coord(x)} and the
columns of \code{recover_rows(x)} and \code{recover_cols(x)}, using the \link{recoverers}.
\code{un_tbl_ord()} removes attributes associated with the tbl_ord class in order
to restore an object that was originally passed to \code{as_tbl_ord}.
}
\examples{
# illustrative ordination: FA of Swiss social data
swiss_fa <- factanal(swiss, factors = 3L, scores = "regression")
print(swiss_fa)

# add the 'tbl_ord' wrapper
swiss_fa_ord <- as_tbl_ord(swiss_fa)
# inspect wrapped model
is_tbl_ord(swiss_fa_ord)
print(swiss_fa_ord)
valid_tbl_ord(swiss_fa_ord)
# unwrap the model
un_tbl_ord(swiss_fa_ord)

# create a 'tbl_ord' directly from row and column factors
# (missing inertia & other attributes)
swiss_fa_ord2 <- make_tbl_ord(rows = swiss_fa$scores, cols = swiss_fa$loadings)
# inspect wrapped factors
is_tbl_ord(swiss_fa_ord2)
print(swiss_fa_ord2)
valid_tbl_ord(swiss_fa_ord2)
# unwrap factors
un_tbl_ord(swiss_fa_ord2)
}
