% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom-axis.r
\name{geom_axis}
\alias{geom_axis}
\title{Axes through the origin}
\usage{
geom_axis(
  mapping = NULL,
  data = NULL,
  stat = "identity",
  position = "identity",
  axis_labels = TRUE,
  axis_ticks = TRUE,
  axis_text = TRUE,
  by = NULL,
  num = NULL,
  tick_length = 0.025,
  text_dodge = 0.03,
  label_dodge = 0.03,
  ...,
  parse = FALSE,
  check_overlap = FALSE,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}} or
\code{\link[ggplot2:aes_]{aes_()}}. If specified and \code{inherit.aes = TRUE} (the
default), it is combined with the default mapping at the top level of the
plot. You must supply \code{mapping} if there is no plot mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{stat}{The statistical transformation to use on the data for this
layer, as a string.}

\item{position}{Position adjustment, either as a string, or the result of
a call to a position adjustment function.}

\item{axis_labels, axis_ticks, axis_text}{Logical; whether to include labels,
tick marks, and text value marks along the axes.}

\item{by, num}{Intervals between elements or number of elements; specify only
one.}

\item{tick_length}{Numeric; the length of the tick marks, as a proportion of
the minimum of the plot width and height.}

\item{text_dodge}{Numeric; the orthogonal distance of the text from the axis,
as a proportion of the minimum of the plot width and height.}

\item{label_dodge}{Numeric; the orthogonal distance of the text from the axis
or isoline, as a proportion of the minimum of the plot width and height.}

\item{...}{Additional arguments passed to \code{\link[ggplot2:layer]{ggplot2::layer()}}.}

\item{parse}{If \code{TRUE}, the labels will be parsed into expressions and
displayed as described in \code{?plotmath}.}

\item{check_overlap}{If \code{TRUE}, text that overlaps previous text in the
same layer will not be plotted. \code{check_overlap} happens at draw time and in
the order of the data. Therefore data should be arranged by the label
column before calling \code{geom_text()}. Note that this argument is not
supported by \code{geom_label()}.}

\item{na.rm}{Passed to \code{\link[ggplot2:layer]{ggplot2::layer()}}.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:borders]{borders()}}.}
}
\value{
A ggproto \link[ggplot2:layer]{layer}.
}
\description{
\code{geom_axis()} renders lines through the origin and the position
of each case or variable.
}
\section{Biplot layers}{

\code{\link[=ggbiplot]{ggbiplot()}} uses \code{\link[ggplot2:fortify]{ggplot2::fortify()}} internally to produce a single data
frame with a \code{.matrix} column distinguishing the subjects (\code{"rows"}) and
variables (\code{"cols"}). The stat layers \code{stat_rows()} and \code{stat_cols()} simply
filter the data frame to one of these two.

The geom layers \verb{geom_rows_*()} and \verb{geom_cols_*()} call the corresponding
stat in order to render plot elements for the corresponding factor matrix.
\verb{geom_dims_*()} selects a default matrix based on common practice, e.g.
points for rows and arrows for columns.
}

\section{Aesthetics}{

\code{geom_axis()} understands the following aesthetics (required aesthetics are
in bold):
\itemize{
\item \strong{\code{x}}
\item \strong{\code{y}}
\item \code{colour}
\item \code{alpha}
\item \code{size}
\item \code{linetype}
\item \code{label}
\item \code{center}, \code{scale}
\item \code{label_colour}, \code{label_alpha}, \code{label_size}, \code{label_angle},
\code{label_hjust}, \code{label_vjust}, \code{label_family}, \code{label_fontface}
\item \code{tick_colour}, \code{tick_alpha}, \code{tick_size}, \code{tick_linetype}
\item \code{text_colour}, \code{text_alpha}, \code{text_size}, \code{text_angle},
\code{text_hjust}, \code{text_vjust}, \code{text_family}, \code{text_fontface}
\item \code{group}
}

The prefixed aesthetics \verb{label_*}, \verb{tick_*}, and \verb{text_*} are used by the
text elements and will inherit any values passed to their un-prefixed
counterparts, if recognized.
}

\examples{
# Reaven & Miller overt & chemical diabetes test data and group classification
head(heplots::Diabetes)

# default (standardized) linear discriminant analysis of groups on tests
diabetes_lda <- MASS::lda(group ~ ., heplots::Diabetes)
# bestow 'tbl_ord' class & augment observation, centroid, and variable fields
as_tbl_ord(diabetes_lda) \%>\%
  augment_ord() \%>\%
  mutate_rows(discriminant = ifelse(
    .element == "active",
    "centroid", "case"
  )) \%>\%
  print() -> diabetes_lda
# row-standard biplot
diabetes_lda \%>\%
  confer_inertia(1) \%>\%
  ggbiplot() +
  theme_bw() + theme_biplot() +
  geom_rows_point(aes(shape = grouping, size = discriminant), alpha = .5) +
  geom_cols_axis(aes(label = name), color = "#888888", num = 8L,
                 text_size = 2.5, label_dodge = .02) +
  ggtitle(
    "LDA of Reaven & Miller diabetes groups",
    "Row-standard biplot of standardized LDA"
  )

# contribution LDA of groups on tests
diabetes_lda <-
  lda_ord(group ~ ., heplots::Diabetes, axes.scale = "contribution")
# bestow 'tbl_ord' class & augment observation, centroid, and variable fields
as_tbl_ord(diabetes_lda) \%>\%
  augment_ord() \%>\%
  mutate_rows(discriminant = ifelse(
    .element == "active",
    "centroid", "case"
  )) \%>\%
  print() -> diabetes_lda
# symmetric biplot
diabetes_lda \%>\%
  confer_inertia(.5) \%>\%
  ggbiplot() +
  theme_bw() + theme_biplot() +
  geom_rows_point(aes(shape = grouping, alpha = discriminant)) +
  geom_cols_axis(color = "#888888", num = 8L,
                 text_size = 2.5, text_dodge = .025) +
  ggtitle(
    "LDA of Reaven & Miller diabetes groups",
    "Symmetric biplot of contribution LDA"
  )
}
\seealso{
Other geom layers: 
\code{\link{geom_isoline}()},
\code{\link{geom_lineranges}()},
\code{\link{geom_origin}()},
\code{\link{geom_text_radiate}()},
\code{\link{geom_unit_circle}()},
\code{\link{geom_vector}()}
}
\concept{geom layers}
