% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list-cancor-tidiers.r
\name{cancor_tidiers}
\alias{cancor_tidiers}
\alias{tidy.cancor}
\alias{tidy_cancor}
\title{Tidy \code{cancor()} list output}
\usage{
tidy_cancor(x, matrix = "xcoef", ...)
}
\arguments{
\item{x}{A list with components \code{cor}, \code{xcoef}, \code{ycoef}, \code{xcenter}, and
\code{ycenter} as returned by \code{\link[stats:cancor]{stats::cancor()}}.}

\item{matrix}{Character specifying which list element should be tidied,
matched to the following options.
\itemize{
\item \code{"xcoef"}: returns information about the estimated coefficients in the
\code{x} variables.
\item \code{"ycoef"}: returns information about the estimated coefficients in the
\code{y} variables
\item \code{"cor"}: returns information about the canonical correlations.
}}

\item{...}{Additional arguments allowed by generics; currently ignored.}
}
\value{
A \link[tibble:tibble]{tibble}.
}
\description{
These tidiers handle the output of \code{cancor()}, which is
effectively an S3 object without a class attribute. It allows \strong{ordr} to
enhance the \link{list_tidiers} provided by \strong{broom}.
}
\details{
\code{\link[=cancor]{cancor()}} returns a named list of 5 elements. These tidiers rely on this
list structure to organize the model output into a tibble.
}
\examples{
# savings data
class(LifeCycleSavings)
pop <- LifeCycleSavings[, 2:3]
oec <- LifeCycleSavings[, -(2:3)]
# canonical correlation analysis
savings_cca <- cancor(pop, oec)

# return the tidied canonical coefficients for the left variables
tidy(savings_cca)
# return the tidied canonical coefficients for the right variables
tidy(savings_cca, matrix = "ycoef")
# return the canonical coefficients, with summary statistics
tidy(savings_cca, matrix = "cor")

# scree plot
ggplot(tidy(savings_cca, matrix = "cor"), aes(x = CC, y = percent)) +
  theme_bw() +
  geom_col() +
  labs(x = "Canonical dimension", y = "Percent of variance")
}
\seealso{
\code{\link[generics:tidy]{generics::tidy()}} \code{\link[stats:cancor]{stats::cancor()}}

Other list tidiers: 
\code{\link{cmdscale_tidiers}},
\code{\link{list_tidiers}}
}
\concept{list tidiers}
