% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inline.R
\name{orbital_inline}
\alias{orbital_inline}
\title{Convert orbital objects to quosures}
\usage{
orbital_inline(x)
}
\arguments{
\item{x}{An \link{orbital} object.}
}
\value{
a list of \link[rlang:defusing-advanced]{quosures}.
}
\description{
Use orbital object splicing function to apply orbital prediction in a quosure
aware function such as \code{\link[dplyr:mutate]{dplyr::mutate()}}.
}
\details{
This function is mostly going to be used for
\href{https://rlang.r-lib.org/reference/topic-inject.html#dots-injection}{Dots Injection}.
This function is used internally in \link[=predict.orbital_class]{predict()}, but
is also exported for user flexibility. Should be used with \verb{!!!} as seen in
the examples.

Note should be taken that using this function modifies existing variables and
creates new variables, unlike \link[=predict.orbital_class]{predict()} which only
returns predictions.
}
\examples{
\dontshow{if (rlang::is_installed(c("recipes", "tidypredict", "workflows"))) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(workflows)
library(recipes)
library(parsnip)

rec_spec <- recipe(mpg ~ ., data = mtcars) \%>\%
  step_normalize(all_numeric_predictors())

lm_spec <- linear_reg()

wf_spec <- workflow(rec_spec, lm_spec)

wf_fit <- fit(wf_spec, mtcars)

orbital_obj <- orbital(wf_fit)

orbital_inline(orbital_obj)

library(dplyr)

mtcars \%>\%
  mutate(!!!orbital_inline(orbital_obj))
\dontshow{\}) # examplesIf}
}
