% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scores.R
\name{scores}
\alias{scores}
\title{Extract scores (propensity, prognostic,...) from a fitted model}
\usage{
scores(object, newdata = NULL, ...)
}
\arguments{
\item{object}{fitted model object determining scores to be generated.}

\item{newdata}{(optional) data frame containing variables with which scores
are produced.}

\item{...}{additional arguments passed to \code{predict}.}
}
\value{
See individual \code{predict} functions.
}
\description{
This is a wrapper for \code{predict}, adapted for use in matching.  Given a
fitted model but no explicit \code{newdata} to \sQuote{predict} from, it
constructs its own \code{newdata} in a manner that's generally better suited
for matching.
}
\details{
Like \code{predict}, its default predictions from a \code{glm} are on
the scale of the linear predictor, not the scale of the response; see
Rosenbaum \& Rubin (1985).  (This default can
be overridden by specifying \code{type="response"}.)
In contrast to \code{predict}, if \code{scores} isn't given an explicit
\code{newdata} argument then it attempts to reconstruct one from the context
in which it is called, rather than from its first argument.  For example, if
it's called within the \code{formula} argument of a call to \code{glm}, its
\code{newdata} is the same data frame that \code{glm} evaluates that formula
in, as opposed to the model frame associated with \code{object}.  See
Examples.

The handling of missing independent variables also differs from that of
\code{predict} in two ways. First, if the data used to generate \code{object}
has \code{NA} values, they're mean-imputed using
\code{\link{fill.NAs}}. Secondly, if \code{newdata} (either the explicit
argument, or the implicit data generated from \code{object}) has \code{NA}
values, they're likewise mean-imputed using \code{\link{fill.NAs}}.  Also,
missingness flags are added to the formula of \code{object}, which is then
re-fit, using \code{\link{fill.NAs}}, prior to calling \code{predict}.

If \code{newdata} is specified and contains no missing data, \code{scores}
returns the same value as \code{predict}.
}
\examples{
data(nuclearplants)
pg <- lm(cost~., data=nuclearplants, subset=(pr==0))
# The following two lines produce identical results.
ps1 <- glm(pr~cap+date+t1+bw+predict(pg, newdata=nuclearplants),
           data=nuclearplants)
ps2 <- glm(pr~cap+date+t1+bw+scores(pg), data=nuclearplants)
}
\references{
P.~R. Rosenbaum and D.~B. Rubin (1985), \sQuote{Constructing a
  control group using multivariate matched sampling methods that incorporate
  the propensity score}, \emph{The American Statistician}, \bold{39} 33--38.
}
\seealso{
\code{\link{predict}}
}
\author{
Josh Errickson
}
