% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optionstrat.R
\name{opteval}
\alias{opteval}
\title{Dual Option Evaluation}
\usage{
opteval(s, x, sigma, t, r, d = 0)
}
\arguments{
\item{s}{Spot price of the underlying asset}

\item{x}{Strike price of the option}

\item{sigma}{Implied volatility of the underlying asset price, defined as the annualized standard deviation of the asset returns}

\item{t}{Time to maturity in years}

\item{r}{Annual continuously-compounded risk-free rate, use the function r.cont}

\item{d}{Annual continuously-compounded dividend yield, use the function r.cont}
}
\value{
Returns a data.frame containing the call and put option premium and greeks:
\itemize{
\item Premium
\item Delta
\item Gamma
\item Vega
\item Theta
\item Rho
}
}
\description{
Creates a data.frame containing both call and put option greeks; delta, gamma, vega, theta, rho and the option premium
}
\examples{
opteval(100, 100, 0.20, (45/365), 0.02, 0.02)
}
