% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/initScenario.R
\name{initScenario}
\alias{initScenario}
\title{Initialize the robust optimization}
\usage{
initScenario(
  coefTable,
  uValue = 1,
  optimisticRule = "expectation",
  fixDistance = 3
)
}
\arguments{
\item{coefTable}{Coefficient table in the expected \emph{optimLanduse} format.}

\item{uValue}{\emph{u} Value. The uncertainty (standard deviation or standard error) is
multiplied with the u value. The value therefore enables scenario analyses with differing
uncertainties in relation to indicator values. Higher u values can be interpreted as a higher
risk aversion of the decision maker.}

\item{optimisticRule}{Either \emph{expectation} or \emph{uncertaintyAdjustedExpectation}.
The rule indicates whether the optimistic outcomes of an indicator are directly
reflected by their expectations or if the indicator is calculated as expectation +
uncertainty when "more is better", expectation - uncertainty respectively when "less is better".
An optimization based on \emph{expectation} considers only downside risks.}

\item{fixDistance}{A two-column table or matrix. The table must
contain the best and the worst performing landuse-type of every uncertainty
scenario, which is influenced by the \emph{uValue}. The difference between
these two variables reflects the uncertainty space, in other words the
distance. This table can always be found (no matter if the distance is fixed
or not) in result list of the \emph{initScenario} function. By default, the
distance is fixed on 3 \emph{fixDistnce = 3}. Fixing the distance allows you to change
the uncertainty level, without changing the uncertainty framework. For
instance, you can then relate the achieved portfolio performance, with a low
uncertainty level, to a wider and constant uncertainty framework within your
analysis; so the \emph{betas} remain comparable with each other over the
course of the uncertainty analysis.}
}
\value{
An initialized optimLanduse S3 object ready for optimization.
}
\description{
The function initializes an \emph{optimLanduse} S3 object on the
basis of a coefficients table. Please note that the coefficients table must follow
the \emph{optimLanduse} format. The expected format is explained in the example on
 \href{https://gitlab.gwdg.de/forest_economics_goettingen/optimlanduse}{GitLab}.
}
\details{
The aim of separating the initialization from the optimization is to save
 computation time in batch analysis. The separated function calls allow the
 user to perform multiple
 optimizations from one initialized object. This could save time in scenario or
 sensitivity analysis.
}
\examples{
require(readxl)
dat <- read_xlsx(exampleData("exampleGosling.xlsx"))

init <- initScenario(dat,
                     uValue = 2,
                     optimisticRule = "expectation",
                     fixDistance = 3)
}
