% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ensemble_models.R
\name{ensemble_models}
\alias{ensemble_models}
\title{Select best models based on ensemble metrics}
\usage{
ensemble_models(
  df_kxi,
  n_models = 4,
  metrics = NULL,
  metrics_exclude = NULL,
  model_subsample = c(0.1, 0.2, 0.5),
  n_models_subsample = 10
)
}
\arguments{
\item{df_kxi}{Output of opticskxi_pipeline function.
Dataframe with models' parameters and OPTICS k-Xi results}

\item{n_models}{Number of best models to return}

\item{metrics}{Names of metrics to use. Any of those computed by
opticskxi_pipeline, e.g. 'sindex', 'ch', 'dunn',
'dunn2', 'widestgap', 'entropy' etc.
NULL for all (8).}

\item{metrics_exclude}{Names of metrics to exclude.
Typically used with metrics = NULL. E.g. 'entropy'.}

\item{model_subsample}{Ratios of best models to consider.}

\item{n_models_subsample}{Number of best models when subsampling.}
}
\value{
Input object df_kxi subsetted to best models according to ensemble
        metrics.
}
\description{
Call ensemble_metrics with varying numbers of rank thresholds to
consider and sum up the ranks from those calls.
}
\examples{
data('m_psych_embeds')
m_psych_embeds = m_psych_embeds[1:200, 1:20]

df_params = expand.grid(n_xi = 4:5, pts = c(5, 10), dist = 'cosine',
                        dim_red = 'ICA', n_dimred_comp = 5)

df_kxi = opticskxi_pipeline(m_psych_embeds, df_params,
                            metrics_dist = 'cosine',
                            n_min_clusters = 2, n_cores = 1,
                            metrics = c('avg.silwidth', 'dunn'))

df_kxi = ensemble_models(df_kxi, n_models = 4,
                         model_subsample = c(0.4, 0.6),
                         n_models_subsample = 4)

}
