% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taxYear.R
\name{taxYear}
\alias{taxYear}
\title{Returns the UK financial tax year for a given date}
\usage{
taxYear(date = Sys.Date(), start = "04-06")
}
\arguments{
\item{date}{Date to be checked}

\item{start}{Provide the month & day that will be used as the first tax day (mm-dd)}
}
\value{
year   The financial year
}
\description{
Based on UK tax year April 6 - April 5, this returns the year (YYYY) 
the tax period covers. Tax Year start date can be overriden.
}
\examples{
# single set of values
taxYear(Sys.Date()) 

# vector of values
taxYear(seq(Sys.Date(),by=1,length=500))

}
\seealso{
Other tax: \code{\link{calcNetIncome}}
}
\concept{tax}
\keyword{financial}
\keyword{tax}
