% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-workbook-wrappers.R
\name{properties-wb}
\alias{properties-wb}
\alias{wb_get_properties}
\alias{wb_set_properties}
\title{Modify workbook properties}
\usage{
wb_get_properties(wb)

wb_set_properties(
  wb,
  creator = NULL,
  title = NULL,
  subject = NULL,
  category = NULL,
  datetime_created = Sys.time(),
  modifier = NULL,
  keywords = NULL,
  comments = NULL,
  manager = NULL,
  company = NULL,
  custom = NULL
)
}
\arguments{
\item{wb}{A Workbook object}

\item{creator}{Creator of the workbook (your name). Defaults to login username or \code{options("openxlsx2.creator")} if set.}

\item{title, subject, category, keywords, comments, manager, company}{Workbook property, a string.}

\item{datetime_created}{The time of the workbook is created}

\item{modifier}{A character string indicating who was the last person to modify the workbook}

\item{custom}{A named vector of custom properties added to the workbook}
}
\value{
A wbWorkbook object, invisibly.
}
\description{
This function is useful for workbooks that are loaded. It can be used to set the
workbook \code{title}, \code{subject} and \code{category} field. Use \code{\link[=wb_workbook]{wb_workbook()}}
to easily set these properties with a new workbook.
}
\details{
To set properties, the following XML core properties are used.
\itemize{
\item title = dc:title
\item subject = dc:subject
\item creator = dc:creator
\item keywords = cp:keywords
\item comments = dc:description
\item modifier = cp:lastModifiedBy
\item datetime_created = dcterms:created
\item datetime_modified = dcterms:modified
\item category = cp:category
}

In addition, manager and company are used.
}
\examples{
file <- system.file("extdata", "openxlsx2_example.xlsx", package = "openxlsx2")
wb <- wb_load(file)
wb$get_properties()

# Add a title to properties
wb$set_properties(title = "my title")
wb$get_properties()
}
\seealso{
\code{\link[=wb_workbook]{wb_workbook()}}
}
