% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-comment.R
\name{comment_internal}
\alias{comment_internal}
\alias{write_comment}
\alias{remove_comment}
\title{Internal comment functions}
\usage{
write_comment(
  wb,
  sheet,
  col = NULL,
  row = NULL,
  comment,
  dims = rowcol_to_dim(row, col)
)

remove_comment(
  wb,
  sheet,
  col = NULL,
  row = NULL,
  gridExpand = TRUE,
  dims = NULL
)
}
\arguments{
\item{wb}{A workbook object}

\item{sheet}{A vector of names or indices of worksheets}

\item{col}{Column a column number of letter. For \code{remove_comment} this can be a range.}

\item{row}{A row number. For \code{remove_comment} this can be a range.}

\item{comment}{A Comment object. See \code{\link[=create_comment]{create_comment()}}.}

\item{dims}{worksheet cell "A1"}

\item{gridExpand}{If \code{TRUE}, all data in rectangle min(rows):max(rows) X min(cols):max(cols)
will be removed.}
}
\description{
Users are advised to use \code{\link[=wb_add_comment]{wb_add_comment()}} and \code{\link[=wb_remove_comment]{wb_remove_comment()}}
}
\keyword{internal}
