% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-style_mgr.R
\name{style_mgr}
\alias{style_mgr}
\title{style manager}
\description{
style manager

style manager
}
\examples{
xlsxFile <- system.file("extdata", "oxlsx2_sheet.xlsx", package = "openxlsx2")
wb <- wb_load(xlsxFile)

# ## start style mgr
# style <- style_mgr$new(wb)
# style$initialize(wb)

# wb$styles_mgr$get_numfmt() |> print()
# wb$styles_mgr$next_numfmt_id() |> print()
# wb$styles_mgr$get_numfmt_id("numFmt-166")

# create new number format
new_numfmt <- create_numfmt(numFmtId = wb$styles_mgr$next_numfmt_id(), formatCode = "#,#")

# add it via stylemgr
wb$styles_mgr$add(new_numfmt, "test")

## get numfmts (invisible)
# z <- wb$styles_mgr$get_numfmt()
# z
wb$styles_mgr$styles$numFmts

## create and add huge font
new_huge_font <- create_font(sz = "20", name = "Arial", b = "1",
                             color = wb_color(hex = "FFFFFFFF"))
wb$styles_mgr$add(new_huge_font, "arial_huge")

## create another font
new_font <- create_font(name = "Arial")
wb$styles_mgr$add(new_font, "arial")

## create and add new fill
new_fill <- create_fill(patternType = "solid", fgColor = wb_color(hex = "FF00224B"))
wb$styles_mgr$add(new_fill, "blue")

# create new style with numfmt enabled
head_xf <- create_cell_style(
  horizontal = "center",
  textRotation = "45",
  numFmtId = "0",
  fontId = wb$styles_mgr$get_font_id("arial_huge"),
  fillId = wb$styles_mgr$get_fill_id("blue")
)

new_xf <- create_cell_style(
  numFmtId = wb$styles_mgr$get_numfmt_id("test"),
  fontId = wb$styles_mgr$get_font_id("arial")
)

## add new styles
wb$styles_mgr$add(head_xf, "head_xf")
wb$styles_mgr$add(new_xf, "new_xf")

## get cell style ids (invisible)
# z <- wb$styles_mgr$get_xf()

## get cell style id
# wb$styles_mgr$get_xf_id("new_xf")

 ## assign styles to cells
wb$set_cell_style("SUM", "B3:I3", wb$styles_mgr$get_xf_id("head_xf"))
wb$set_cell_style("SUM", "C7:C16", wb$styles_mgr$get_xf_id("new_xf"))
# wb_open(wb)

}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{numfmt}}{numfmt-ids}

\item{\code{font}}{font-ids}

\item{\code{fill}}{fill-ids}

\item{\code{border}}{border-ids}

\item{\code{xf}}{xf-ids}

\item{\code{cellStyle}}{cellStyle-ids}

\item{\code{cellStyleXf}}{cellStyleXf-ids}

\item{\code{dxf}}{dxf-ids}

\item{\code{tableStyle}}{tableStyle-ids}

\item{\code{defaultTableStyle}}{defaultTableStyle}

\item{\code{defaultPivotStyle}}{defaultPivotStyle}

\item{\code{styles}}{styles as xml}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-wbStylesMgr-new}{\code{style_mgr$new()}}
\item \href{#method-wbStylesMgr-get_numfmt}{\code{style_mgr$get_numfmt()}}
\item \href{#method-wbStylesMgr-get_font}{\code{style_mgr$get_font()}}
\item \href{#method-wbStylesMgr-get_fill}{\code{style_mgr$get_fill()}}
\item \href{#method-wbStylesMgr-get_border}{\code{style_mgr$get_border()}}
\item \href{#method-wbStylesMgr-get_xf}{\code{style_mgr$get_xf()}}
\item \href{#method-wbStylesMgr-get_cellStyle}{\code{style_mgr$get_cellStyle()}}
\item \href{#method-wbStylesMgr-get_cellStyleXf}{\code{style_mgr$get_cellStyleXf()}}
\item \href{#method-wbStylesMgr-get_dxf}{\code{style_mgr$get_dxf()}}
\item \href{#method-wbStylesMgr-get_numfmt_id}{\code{style_mgr$get_numfmt_id()}}
\item \href{#method-wbStylesMgr-get_font_id}{\code{style_mgr$get_font_id()}}
\item \href{#method-wbStylesMgr-get_fill_id}{\code{style_mgr$get_fill_id()}}
\item \href{#method-wbStylesMgr-get_border_id}{\code{style_mgr$get_border_id()}}
\item \href{#method-wbStylesMgr-get_xf_id}{\code{style_mgr$get_xf_id()}}
\item \href{#method-wbStylesMgr-get_cellStyle_id}{\code{style_mgr$get_cellStyle_id()}}
\item \href{#method-wbStylesMgr-get_cellStyleXf_id}{\code{style_mgr$get_cellStyleXf_id()}}
\item \href{#method-wbStylesMgr-get_dxf_id}{\code{style_mgr$get_dxf_id()}}
\item \href{#method-wbStylesMgr-get_tableStyle_id}{\code{style_mgr$get_tableStyle_id()}}
\item \href{#method-wbStylesMgr-next_numfmt_id}{\code{style_mgr$next_numfmt_id()}}
\item \href{#method-wbStylesMgr-next_font_id}{\code{style_mgr$next_font_id()}}
\item \href{#method-wbStylesMgr-next_fill_id}{\code{style_mgr$next_fill_id()}}
\item \href{#method-wbStylesMgr-next_border_id}{\code{style_mgr$next_border_id()}}
\item \href{#method-wbStylesMgr-next_xf_id}{\code{style_mgr$next_xf_id()}}
\item \href{#method-wbStylesMgr-next_cellstyle_id}{\code{style_mgr$next_cellstyle_id()}}
\item \href{#method-wbStylesMgr-next_cellstylexf_id}{\code{style_mgr$next_cellstylexf_id()}}
\item \href{#method-wbStylesMgr-next_dxf_id}{\code{style_mgr$next_dxf_id()}}
\item \href{#method-wbStylesMgr-next_tableStyle_id}{\code{style_mgr$next_tableStyle_id()}}
\item \href{#method-wbStylesMgr-getstyle_ids}{\code{style_mgr$getstyle_ids()}}
\item \href{#method-wbStylesMgr-add}{\code{style_mgr$add()}}
\item \href{#method-wbStylesMgr-init_named_style}{\code{style_mgr$init_named_style()}}
\item \href{#method-wbStylesMgr-clone}{\code{style_mgr$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbStylesMgr-new"></a>}}
\if{latex}{\out{\hypertarget{method-wbStylesMgr-new}{}}}
\subsection{Method \code{new()}}{
Creates a new \code{wbStylesMgr} object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{style_mgr$new(
  numfmt = NA,
  font = NA,
  fill = NA,
  border = NA,
  xf = NA,
  cellStyle = NA,
  cellStyleXf = NA,
  dxf = NA,
  styles = NA
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{numfmt}}{numfmt}

\item{\code{font}}{font}

\item{\code{fill}}{fill}

\item{\code{border}}{border}

\item{\code{xf}}{xf}

\item{\code{cellStyle}}{cellStyles}

\item{\code{cellStyleXf}}{cellStylesXf}

\item{\code{dxf}}{dxf}

\item{\code{styles}}{styles}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
a \code{wbStylesMgr} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbStylesMgr-get_numfmt"></a>}}
\if{latex}{\out{\hypertarget{method-wbStylesMgr-get_numfmt}{}}}
\subsection{Method \code{get_numfmt()}}{
get numfmt ids
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{style_mgr$get_numfmt()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbStylesMgr-get_font"></a>}}
\if{latex}{\out{\hypertarget{method-wbStylesMgr-get_font}{}}}
\subsection{Method \code{get_font()}}{
get font ids
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{style_mgr$get_font()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbStylesMgr-get_fill"></a>}}
\if{latex}{\out{\hypertarget{method-wbStylesMgr-get_fill}{}}}
\subsection{Method \code{get_fill()}}{
get fill ids
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{style_mgr$get_fill()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbStylesMgr-get_border"></a>}}
\if{latex}{\out{\hypertarget{method-wbStylesMgr-get_border}{}}}
\subsection{Method \code{get_border()}}{
get border ids
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{style_mgr$get_border()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbStylesMgr-get_xf"></a>}}
\if{latex}{\out{\hypertarget{method-wbStylesMgr-get_xf}{}}}
\subsection{Method \code{get_xf()}}{
get xf ids
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{style_mgr$get_xf()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbStylesMgr-get_cellStyle"></a>}}
\if{latex}{\out{\hypertarget{method-wbStylesMgr-get_cellStyle}{}}}
\subsection{Method \code{get_cellStyle()}}{
get cellstyle ids
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{style_mgr$get_cellStyle()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbStylesMgr-get_cellStyleXf"></a>}}
\if{latex}{\out{\hypertarget{method-wbStylesMgr-get_cellStyleXf}{}}}
\subsection{Method \code{get_cellStyleXf()}}{
get cellstylexf ids
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{style_mgr$get_cellStyleXf()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbStylesMgr-get_dxf"></a>}}
\if{latex}{\out{\hypertarget{method-wbStylesMgr-get_dxf}{}}}
\subsection{Method \code{get_dxf()}}{
get dxf ids
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{style_mgr$get_dxf()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbStylesMgr-get_numfmt_id"></a>}}
\if{latex}{\out{\hypertarget{method-wbStylesMgr-get_numfmt_id}{}}}
\subsection{Method \code{get_numfmt_id()}}{
get numfmt id by name
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{style_mgr$get_numfmt_id(name)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{name}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbStylesMgr-get_font_id"></a>}}
\if{latex}{\out{\hypertarget{method-wbStylesMgr-get_font_id}{}}}
\subsection{Method \code{get_font_id()}}{
get font id by name
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{style_mgr$get_font_id(name)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{name}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbStylesMgr-get_fill_id"></a>}}
\if{latex}{\out{\hypertarget{method-wbStylesMgr-get_fill_id}{}}}
\subsection{Method \code{get_fill_id()}}{
get fill id by name
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{style_mgr$get_fill_id(name)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{name}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbStylesMgr-get_border_id"></a>}}
\if{latex}{\out{\hypertarget{method-wbStylesMgr-get_border_id}{}}}
\subsection{Method \code{get_border_id()}}{
get border id by name
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{style_mgr$get_border_id(name)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{name}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbStylesMgr-get_xf_id"></a>}}
\if{latex}{\out{\hypertarget{method-wbStylesMgr-get_xf_id}{}}}
\subsection{Method \code{get_xf_id()}}{
get xf id by name
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{style_mgr$get_xf_id(name)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{name}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbStylesMgr-get_cellStyle_id"></a>}}
\if{latex}{\out{\hypertarget{method-wbStylesMgr-get_cellStyle_id}{}}}
\subsection{Method \code{get_cellStyle_id()}}{
get cellstyle id by name
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{style_mgr$get_cellStyle_id(name)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{name}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbStylesMgr-get_cellStyleXf_id"></a>}}
\if{latex}{\out{\hypertarget{method-wbStylesMgr-get_cellStyleXf_id}{}}}
\subsection{Method \code{get_cellStyleXf_id()}}{
get cellstyleXf id by name
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{style_mgr$get_cellStyleXf_id(name)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{name}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbStylesMgr-get_dxf_id"></a>}}
\if{latex}{\out{\hypertarget{method-wbStylesMgr-get_dxf_id}{}}}
\subsection{Method \code{get_dxf_id()}}{
get dxf id by name
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{style_mgr$get_dxf_id(name)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{name}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbStylesMgr-get_tableStyle_id"></a>}}
\if{latex}{\out{\hypertarget{method-wbStylesMgr-get_tableStyle_id}{}}}
\subsection{Method \code{get_tableStyle_id()}}{
get tableStyle id by name
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{style_mgr$get_tableStyle_id(name)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{name}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbStylesMgr-next_numfmt_id"></a>}}
\if{latex}{\out{\hypertarget{method-wbStylesMgr-next_numfmt_id}{}}}
\subsection{Method \code{next_numfmt_id()}}{
get next numfmt id
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{style_mgr$next_numfmt_id()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbStylesMgr-next_font_id"></a>}}
\if{latex}{\out{\hypertarget{method-wbStylesMgr-next_font_id}{}}}
\subsection{Method \code{next_font_id()}}{
get next font id
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{style_mgr$next_font_id()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbStylesMgr-next_fill_id"></a>}}
\if{latex}{\out{\hypertarget{method-wbStylesMgr-next_fill_id}{}}}
\subsection{Method \code{next_fill_id()}}{
get next fill id
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{style_mgr$next_fill_id()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbStylesMgr-next_border_id"></a>}}
\if{latex}{\out{\hypertarget{method-wbStylesMgr-next_border_id}{}}}
\subsection{Method \code{next_border_id()}}{
get next border id
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{style_mgr$next_border_id()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbStylesMgr-next_xf_id"></a>}}
\if{latex}{\out{\hypertarget{method-wbStylesMgr-next_xf_id}{}}}
\subsection{Method \code{next_xf_id()}}{
get next xf id
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{style_mgr$next_xf_id()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbStylesMgr-next_cellstyle_id"></a>}}
\if{latex}{\out{\hypertarget{method-wbStylesMgr-next_cellstyle_id}{}}}
\subsection{Method \code{next_cellstyle_id()}}{
get next xf id
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{style_mgr$next_cellstyle_id()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbStylesMgr-next_cellstylexf_id"></a>}}
\if{latex}{\out{\hypertarget{method-wbStylesMgr-next_cellstylexf_id}{}}}
\subsection{Method \code{next_cellstylexf_id()}}{
get next xf id
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{style_mgr$next_cellstylexf_id()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbStylesMgr-next_dxf_id"></a>}}
\if{latex}{\out{\hypertarget{method-wbStylesMgr-next_dxf_id}{}}}
\subsection{Method \code{next_dxf_id()}}{
get next dxf id
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{style_mgr$next_dxf_id()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbStylesMgr-next_tableStyle_id"></a>}}
\if{latex}{\out{\hypertarget{method-wbStylesMgr-next_tableStyle_id}{}}}
\subsection{Method \code{next_tableStyle_id()}}{
get next tableStyle id
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{style_mgr$next_tableStyle_id()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbStylesMgr-getstyle_ids"></a>}}
\if{latex}{\out{\hypertarget{method-wbStylesMgr-getstyle_ids}{}}}
\subsection{Method \code{getstyle_ids()}}{
get named style ids
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{style_mgr$getstyle_ids(name)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{name}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbStylesMgr-add"></a>}}
\if{latex}{\out{\hypertarget{method-wbStylesMgr-add}{}}}
\subsection{Method \code{add()}}{
add entry
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{style_mgr$add(style, style_name, skip_duplicates = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{style}}{new_style}

\item{\code{style_name}}{a unique name identifying the style}

\item{\code{skip_duplicates}}{should duplicates be added?}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbStylesMgr-init_named_style"></a>}}
\if{latex}{\out{\hypertarget{method-wbStylesMgr-init_named_style}{}}}
\subsection{Method \code{init_named_style()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{style_mgr$init_named_style(name, font_name = "Arial", font_size = 11)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{style name}

\item{\code{font_name, font_size}}{optional else the default of the theme}

\item{\code{wb}}{wbWorkbook}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
possible styles are:
"20\% - Accent1"
"20\% - Accent2"
"20\% - Accent3"
"20\% - Accent4"
"20\% - Accent5"
"20\% - Accent6"
"40\% - Accent1"
"40\% - Accent2"
"40\% - Accent3"
"40\% - Accent4"
"40\% - Accent5"
"40\% - Accent6"
"60\% - Accent1"
"60\% - Accent2"
"60\% - Accent3"
"60\% - Accent4"
"60\% - Accent5"
"60\% - Accent6"
"Accent1"
"Accent2"
"Accent3"
"Accent4"
"Accent5"
"Accent6"
"Bad"
"Calculation"
"Check Cell"
"Comma"
"Comma [0]"
"Currency"
"Currency [0]"
"Explanatory Text"
"Good"
"Heading 1"
"Heading 2"
"Heading 3"
"Heading 4"
"Input"
"Linked Cell"
”Neutral"
"Normal"
"Note"
"Output"
"Per cent"
"Title"
"Total"
"Warning Text"
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbStylesMgr-clone"></a>}}
\if{latex}{\out{\hypertarget{method-wbStylesMgr-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{style_mgr$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
