% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-workbook-wrappers.R
\name{wb_add_drawing}
\alias{wb_add_drawing}
\title{add drawings to workbook}
\usage{
wb_add_drawing(wb, sheet = current_sheet(), xml, dims = "A1:H8")
}
\arguments{
\item{wb}{a wbWorkbook}

\item{sheet}{a sheet in the workbook}

\item{xml}{the drawing xml as character or file}

\item{dims}{the dimension where the drawing is added. Can be NULL}
}
\description{
add drawings to workbook
}
\examples{
if (requireNamespace("rvg") && interactive()) {

## rvg example
require(rvg)
tmp <- tempfile(fileext = ".xml")
dml_xlsx(file =  tmp)
plot(1,1)
dev.off()

wb <- wb_workbook()$
  add_worksheet()$
  add_drawing(xml = tmp)$
  add_drawing(xml = tmp, dims = NULL)
}
}
