% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny.R
\name{register_shiny_metrics}
\alias{register_shiny_metrics}
\title{Metrics for Shiny Applications}
\usage{
register_shiny_metrics(app, registry = openmetrics::global_registry())
}
\arguments{
\item{app}{An object created with \code{\link[shiny:shinyApp]{shiny::shinyApp()}}.}

\item{registry}{A \code{Registry} object. See \code{\link[=registry]{registry()}}.}
}
\value{
A modified Shiny app object.
}
\description{
Automatically wrap a Shiny app, adding metrics for the current session count
and the duration of reactive flushes, and then expose them on a \verb{/metrics}
endpoint.

The endpoint will check the \code{METRICS_HTTP_AUTHORIZATION} environment
variable, and if present will use it as the expected
\href{https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Authorization}{\code{Authorization}}
header of the request to the \verb{/metrics} endpoint. This can be used to
implement basic HTTP authentication for access to runtime metrics.
}
