% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weather_now.R
\name{weather_now}
\alias{weather_now}
\title{Retrieve Current Weather from the Open-Meteo API}
\usage{
weather_now(location, response_units = NULL, timezone = "auto")
}
\arguments{
\item{location}{Required. The location for which data will be retrieved.
Supplied as either a \code{c(latitude,longitude)} WGS84 coordinate pair or a
place name string (with co-ordinates obtained via \code{\link[=geocode]{geocode()}}).}

\item{response_units}{Supply to convert temperature, windspeed, or
precipitation units. This defaults to: \verb{list(temperature_unit = "celsius",}
\verb{windspeed_unit = "kmh", precipitation_unit = "mm")}}

\item{timezone}{specify timezone for time data as a string, i.e.
"australia/sydney" (defaults to "auto", the timezone local to the specified
\code{location}).}
}
\value{
Current weather conditions: temperature, windspeed, wind direction
and weathercode.
}
\description{
\code{weather_now()} calls the Open-Meteo weather API for the most recently
recorded weather conditions a given location. Location is provided either as
string or \code{c(latitude,longitude)}.
}
\examples{
\donttest{
# current weather in Montreal
weather_now("Montreal")

# current weather at the North Pole in Imperial units
weather_now(c(90, 0),
  response_units = list(
    temperature_unit = "fahrenheit",
    windspeed_unit = "mph"
  )
)
}
}
