% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/services.R
\name{update_service}
\alias{update_service}
\title{Modifies a service}
\usage{
update_service(
  service,
  type = NULL,
  graph = NULL,
  title = NULL,
  description = NULL,
  enabled = NULL,
  configuration = NULL,
  plan = NULL,
  budget = NULL,
  con = NULL,
  ...
)
}
\arguments{
\item{service}{the Service or its ID}

\item{type}{character - the OGC web service type name to be created}

\item{graph}{A \code{\link[=Graph]{Graph()}}, a function returning a \code{\link[=ProcessNode]{ProcessNode()}} as an endpoint or the \code{\link[=ProcessNode]{ProcessNode()}}
will return the results}

\item{title}{character (optional) - the title of for the service}

\item{description}{character (optional) - the description for the service}

\item{enabled}{logical - whether the service shall be active for querying or disabled}

\item{configuration}{a list of service creation configuration}

\item{plan}{character - the billing plan}

\item{budget}{numeric - the amount of credits that can be spent for this service}

\item{con}{connected and authorized openEO client object (optional) otherwise \code{\link[=active_connection]{active_connection()}}
is used.}

\item{...}{additional parameters passed to jsonlite::toJSON() (like 'digits')}
}
\value{
Service object
}
\description{
The function updates a service with the given information. If a parameter is NULL then it will
not be overwritten on the back-end. If the parameter is set to NA then the value on the back-end
will be deleted and set to NULL.
}
