% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/user.R
\name{login}
\alias{login}
\title{Log in on a specific back-end}
\usage{
login(
  user = NULL,
  password = NULL,
  login_type = NULL,
  provider = NULL,
  config = NULL,
  con = NULL
)
}
\arguments{
\item{user}{the user name}

\item{password}{the password}

\item{login_type}{either NULL, 'basic' or 'oidc'. This refers to the login mechanism that shall be used. NULL disables authentication.}

\item{provider}{provider object as obtained by 'list_oidc_providers()'}

\item{config}{named list containing 'client_id' and 'secret' or a path to the configuration file (type JSON)}

\item{con}{connected back-end connection (optional) otherwise \code{\link{active_connection}}
is used.}
}
\value{
a connected and authenticated back-end connection
}
\description{
Retrieves the bearer-token from the back-end by sending user name and password to the back-end. This step
is usually performed during the 'connect' step. If you are only connected to a back-end in order to 
explore the capabilities and want to compute something, then you need to log in afterwards.
}
\examples{
\dontrun{
# simple connection without login to maybe explore the capabilities of a back-end first
# the URL won't work and is just to demonstrate how to write the code
con = connect(host='http://example.openeo.org',version='1.0.0')

# credentials are dummy values
login(user='user',password='password',login_type='basic', con=con)

# or alternatively the oidc login
login(login_type='oidc', provider=provider, config=config)
}
}
